// ************************************************************************* //
//                        CurveScriptingPluginInfo.C
// ************************************************************************* //
#include <CurvePluginInfo.h>
#include <PyCurveAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Curve_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Curve plot.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new CurveScriptingPluginInfo;
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
CurveScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyCurveAttributes_StartUp((CurveAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void *
CurveScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCurveAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Curve plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

bool
CurveScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCurveAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
CurveScriptingPluginInfo::SetLogging(bool val)
{
    PyCurveAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: CurveScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue May 7 12:59:58 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
CurveScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCurveAttributes_SetDefaults((const CurveAttributes *)atts);
}
