// ************************************************************************* //
//  File: CurveGUIPluginInfo.C
// ************************************************************************* //

#include <CurvePluginInfo.h>
#include <CurveAttributes.h>
#include <QvisCurvePlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Curve_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Curve plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Aug 1 20:32:43 PST 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new CurveGUIPluginInfo;
}

// ****************************************************************************
//  Method: CurveGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Aug 1 20:32:43 PST 2003
//
// ****************************************************************************

const char *
CurveGUIPluginInfo::GetMenuName() const
{
    return "Curve";
}


// ****************************************************************************
// Method: CurveGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Aug 1 20:32:43 PST 2003
//
// Modifications:
//   
// ****************************************************************************

int
CurveGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_CURVE;
}

// ****************************************************************************
//  Method: CurveGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Aug 1 20:32:43 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
CurveGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisCurvePlotWindow(type, (CurveAttributes *)attr,
        "Curve plot attributes", "Curve plot", notepad);
}

// ****************************************************************************
//  Method: CurveGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Aug 1 20:32:43 PST 2003
//
// ****************************************************************************

#include <Curve.xpm>
const char **
CurveGUIPluginInfo::XPMIconData() const
{
    return Curve_xpm;
}
