package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: CurveAttributes
//
// Purpose:
//    Attributes for the xy plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Dec 23 13:35:22 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class CurveAttributes extends AttributeSubject implements Plugin
{
    public CurveAttributes()
    {
        super(7);

        lineStyle = 0;
        lineWidth = 0;
        color = new ColorAttribute(0, 0, 0);
        showLabels = true;
        designator = new String("(null)");
        showPoints = false;
        pointSize = 5;
    }

    public CurveAttributes(CurveAttributes obj)
    {
        super(7);

        lineStyle = obj.lineStyle;
        lineWidth = obj.lineWidth;
        color = new ColorAttribute(obj.color);
        showLabels = obj.showLabels;
        designator = new String(obj.designator);
        showPoints = obj.showPoints;
        pointSize = obj.pointSize;

        SelectAll();
    }

    public boolean equals(CurveAttributes obj)
    {
        // Create the return value
        return ((lineStyle == obj.lineStyle) &&
                (lineWidth == obj.lineWidth) &&
                (color == obj.color) &&
                (showLabels == obj.showLabels) &&
                (designator == obj.designator) &&
                (showPoints == obj.showPoints) &&
                (pointSize == obj.pointSize));
    }

    public String GetName() { return "Curve"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLineStyle(int lineStyle_)
    {
        lineStyle = lineStyle_;
        Select(0);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(1);
    }

    public void SetColor(ColorAttribute color_)
    {
        color = color_;
        Select(2);
    }

    public void SetShowLabels(boolean showLabels_)
    {
        showLabels = showLabels_;
        Select(3);
    }

    public void SetDesignator(String designator_)
    {
        designator = designator_;
        Select(4);
    }

    public void SetShowPoints(boolean showPoints_)
    {
        showPoints = showPoints_;
        Select(5);
    }

    public void SetPointSize(double pointSize_)
    {
        pointSize = pointSize_;
        Select(6);
    }

    // Property getting methods
    public int            GetLineStyle() { return lineStyle; }
    public int            GetLineWidth() { return lineWidth; }
    public ColorAttribute GetColor() { return color; }
    public boolean        GetShowLabels() { return showLabels; }
    public String         GetDesignator() { return designator; }
    public boolean        GetShowPoints() { return showPoints; }
    public double         GetPointSize() { return pointSize; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(lineStyle);
        if(WriteSelect(1, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(2, buf))
            color.Write(buf);
        if(WriteSelect(3, buf))
            buf.WriteBool(showLabels);
        if(WriteSelect(4, buf))
            buf.WriteString(designator);
        if(WriteSelect(5, buf))
            buf.WriteBool(showPoints);
        if(WriteSelect(6, buf))
            buf.WriteDouble(pointSize);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetLineStyle(buf.ReadInt());
                break;
            case 1:
                SetLineWidth(buf.ReadInt());
                break;
            case 2:
                color.Read(buf);
                Select(2);
                break;
            case 3:
                SetShowLabels(buf.ReadBool());
                break;
            case 4:
                SetDesignator(buf.ReadString());
                break;
            case 5:
                SetShowPoints(buf.ReadBool());
                break;
            case 6:
                SetPointSize(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private int            lineStyle;
    private int            lineWidth;
    private ColorAttribute color;
    private boolean        showLabels;
    private String         designator;
    private boolean        showPoints;
    private double         pointSize;
}

