#include <CurveAttributes.h>
#include <DataNode.h>
#include <Line.h>

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Constructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes() : AttributeSubject("iiabsbd"),
    color(0, 0, 0)
{
    lineStyle = 0;
    lineWidth = 0;
    showLabels = true;
    showPoints = false;
    pointSize = 5;
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Copy constructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes(const CurveAttributes &obj) : AttributeSubject("iiabsbd")
{
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    color = obj.color;
    showLabels = obj.showLabels;
    designator = obj.designator;
    showPoints = obj.showPoints;
    pointSize = obj.pointSize;

    SelectAll();
}

// ****************************************************************************
// Method: CurveAttributes::~CurveAttributes
//
// Purpose: 
//   Destructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::~CurveAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CurveAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
CurveAttributes::operator = (const CurveAttributes &obj)
{
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    color = obj.color;
    showLabels = obj.showLabels;
    designator = obj.designator;
    showPoints = obj.showPoints;
    pointSize = obj.pointSize;

    SelectAll();
}

// ****************************************************************************
// Method: CurveAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::operator == (const CurveAttributes &obj) const
{
    // Create the return value
    return ((lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (color == obj.color) &&
            (showLabels == obj.showLabels) &&
            (designator == obj.designator) &&
            (showPoints == obj.showPoints) &&
            (pointSize == obj.pointSize));
}

// ****************************************************************************
// Method: CurveAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::operator != (const CurveAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CurveAttributes::TypeName
//
// Purpose: 
//   Type name method for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
CurveAttributes::TypeName() const
{
    return "CurveAttributes";
}

bool
CurveAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const CurveAttributes *tmp = (const CurveAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "Line")
    {
        const Line *tmp = (const Line*)atts;
        SetDesignator(tmp->GetDesignator());
        SetColor(tmp->GetColor());
        retval = true;
    }

    return retval;
}

AttributeSubject *
CurveAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new CurveAttributes(*this);
    }
    else if(tname == "Line")
    {
        Line *line = new Line;
        line->SetDesignator(GetDesignator());
        line->SetColor(GetColor());
        line->SetLineStyle(GetLineStyle());
        line->SetLineWidth(GetLineWidth());
        retval = line;
    }

    return retval;
}

// ****************************************************************************
// Method: CurveAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CurveAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CurveAttributes(*this);
    else
        retval = new CurveAttributes;

    return retval;
}

// ****************************************************************************
// Method: CurveAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
CurveAttributes::SelectAll()
{
    Select(0, (void *)&lineStyle);
    Select(1, (void *)&lineWidth);
    Select(2, (void *)&color);
    Select(3, (void *)&showLabels);
    Select(4, (void *)&designator);
    Select(5, (void *)&showPoints);
    Select(6, (void *)&pointSize);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CurveAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CurveAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CurveAttributes.
    DataNode *node = new DataNode("CurveAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showLabels", showLabels));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showPoints", showPoints));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSize", pointSize));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CurveAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
CurveAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CurveAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("showLabels")) != 0)
        SetShowLabels(node->AsBool());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
    if((node = searchNode->GetNode("showPoints")) != 0)
        SetShowPoints(node->AsBool());
    if((node = searchNode->GetNode("pointSize")) != 0)
        SetPointSize(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CurveAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(0, (void *)&lineStyle);
}

void
CurveAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(1, (void *)&lineWidth);
}

void
CurveAttributes::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(2, (void *)&color);
}

void
CurveAttributes::SetShowLabels(bool showLabels_)
{
    showLabels = showLabels_;
    Select(3, (void *)&showLabels);
}

void
CurveAttributes::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(4, (void *)&designator);
}

void
CurveAttributes::SetShowPoints(bool showPoints_)
{
    showPoints = showPoints_;
    Select(5, (void *)&showPoints);
}

void
CurveAttributes::SetPointSize(double pointSize_)
{
    pointSize = pointSize_;
    Select(6, (void *)&pointSize);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
CurveAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
CurveAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
CurveAttributes::GetColor() const
{
    return color;
}

ColorAttribute &
CurveAttributes::GetColor()
{
    return color;
}

bool
CurveAttributes::GetShowLabels() const
{
    return showLabels;
}

const std::string &
CurveAttributes::GetDesignator() const
{
    return designator;
}

std::string &
CurveAttributes::GetDesignator()
{
    return designator;
}

bool
CurveAttributes::GetShowPoints() const
{
    return showPoints;
}

double
CurveAttributes::GetPointSize() const
{
    return pointSize;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CurveAttributes::SelectColor()
{
    Select(2, (void *)&color);
}

void
CurveAttributes::SelectDesignator()
{
    Select(4, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CurveAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
CurveAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Line Style";
        case 1:  return "Line Width";
        case 2:  return "Color";
        case 3:  return "Labels";
        case 4:  return "Designator";
        case 5:  return "showPoints";
        case 6:  return "pointSize";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CurveAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CurveAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_linestyle;
        case 1:  return FieldType_linewidth;
        case 2:  return FieldType_color;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_string;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CurveAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
CurveAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "linestyle";
        case 1:  return "linewidth";
        case 2:  return "color";
        case 3:  return "bool";
        case 4:  return "string";
        case 5:  return "bool";
        case 6:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CurveAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 23 13:34:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CurveAttributes &obj = *((const CurveAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 1:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 2:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case 3:
        {  // new scope
        retval = (showLabels == obj.showLabels);
        }
        break;
    case 4:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    case 5:
        {  // new scope
        retval = (showPoints == obj.showPoints);
        }
        break;
    case 6:
        {  // new scope
        retval = (pointSize == obj.pointSize);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
CurveAttributes::ChangesRequireRecalculation(const CurveAttributes &obj) const
{
    return false;
}

void
CurveAttributes::Print(ostream &out, bool selected_only) const
{
    out << "CurveAttributes" << "\n";
    out << "{";
    for(int i = 0; i < NumAttributes(); ++i)
    {
        if(selected_only && !IsSelected(i))
            continue;

        switch(i)
        {
          case  0: out << "lineStyle=  " << GetLineStyle();      break;
          case  1: out << "lineWidth=  " << GetLineWidth();      break;
          case  2: double color[4];
                   GetColor().GetRgba(color);
                   out << "color=      " 
                       << color[0] << " " << color[1] << " " 
                       << color[2] << " " << color[3];
                   GetDesignator();    break;
          case  3: out << "showLabels= " << GetShowLabels();    break;
          case  4: out << "designator= " << GetDesignator().c_str();    break;
          case  5: out << "showPoints= " << GetShowPoints();    break;
          case  6: out << "pointSize=  " << GetPointSize();    break;
        }
        out << ",";
    }

    out << "}";
}

