#include <PyContourAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyContourAttributes
//
// Purpose: 
//   This class contains the plot attributes for the contour plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Jan 13 18:06:31 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a ContourAttributes.
//
struct ContourAttributesObject
{
    PyObject_HEAD
    ContourAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewContourAttributes();

static PyObject *
ContourAttributes_Notify(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_SetDefaultPalette(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=defaultPalette, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetDefaultPalette(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=defaultPalette, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
ContourAttributes_SetChangedColors(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    unsignedCharVector  &vec = obj->data->GetChangedColors();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the changedColors in the object as modified.
    obj->data->SelectChangedColors();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetChangedColors(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the changedColors.
    const unsignedCharVector &changedColors = obj->data->GetChangedColors();
    PyObject *retval = PyTuple_New(changedColors.size());
    for(int i = 0; i < changedColors.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(changedColors[i])));
    return retval;
}

static PyObject *
ContourAttributes_SetColorType(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(ContourAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetColorType(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

static PyObject *
ContourAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
ContourAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
ContourAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
ContourAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
ContourAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
ContourAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
ContourAttributes_SetContourNLevels(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourNLevels in the object.
    obj->data->SetContourNLevels(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetContourNLevels(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourNLevels()));
    return retval;
}

static PyObject *
ContourAttributes_SetContourValue(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourValue in the object as modified.
    obj->data->SelectContourValue();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetContourValue(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourValue.
    const doubleVector &contourValue = obj->data->GetContourValue();
    PyObject *retval = PyTuple_New(contourValue.size());
    for(int i = 0; i < contourValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourValue[i]));
    return retval;
}

static PyObject *
ContourAttributes_SetContourPercent(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourPercent();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourPercent in the object as modified.
    obj->data->SelectContourPercent();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetContourPercent(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourPercent.
    const doubleVector &contourPercent = obj->data->GetContourPercent();
    PyObject *retval = PyTuple_New(contourPercent.size());
    for(int i = 0; i < contourPercent.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourPercent[i]));
    return retval;
}

static PyObject *
ContourAttributes_SetContourMethod(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetContourMethod(ContourAttributes::Select_by(ival));
    else
    {
        fprintf(stderr, "An invalid contourMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Level, Value, Percent.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetContourMethod(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourMethod()));
    return retval;
}

static PyObject *
ContourAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
ContourAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ContourAttributes_SetMin(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetMin(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
ContourAttributes_SetMax(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetMax(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
ContourAttributes_SetScaling(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetScaling(ContourAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Linear, Log.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetScaling(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

static PyObject *
ContourAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ContourAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}



static struct PyMethodDef ContourAttributes_methods[] = {
    {"Notify", ContourAttributes_Notify, METH_VARARGS},
    {"SetDefaultPalette", ContourAttributes_SetDefaultPalette, METH_VARARGS},
    {"GetDefaultPalette", ContourAttributes_GetDefaultPalette, METH_VARARGS},
    {"SetChangedColors", ContourAttributes_SetChangedColors, METH_VARARGS},
    {"GetChangedColors", ContourAttributes_GetChangedColors, METH_VARARGS},
    {"SetColorType", ContourAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", ContourAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", ContourAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", ContourAttributes_GetColorTableName, METH_VARARGS},
    {"SetLegendFlag", ContourAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", ContourAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", ContourAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", ContourAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", ContourAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", ContourAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", ContourAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", ContourAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", ContourAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", ContourAttributes_GetMultiColor, METH_VARARGS},
    {"SetContourNLevels", ContourAttributes_SetContourNLevels, METH_VARARGS},
    {"GetContourNLevels", ContourAttributes_GetContourNLevels, METH_VARARGS},
    {"SetContourValue", ContourAttributes_SetContourValue, METH_VARARGS},
    {"GetContourValue", ContourAttributes_GetContourValue, METH_VARARGS},
    {"SetContourPercent", ContourAttributes_SetContourPercent, METH_VARARGS},
    {"GetContourPercent", ContourAttributes_GetContourPercent, METH_VARARGS},
    {"SetContourMethod", ContourAttributes_SetContourMethod, METH_VARARGS},
    {"GetContourMethod", ContourAttributes_GetContourMethod, METH_VARARGS},
    {"SetMinFlag", ContourAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", ContourAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", ContourAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", ContourAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMin", ContourAttributes_SetMin, METH_VARARGS},
    {"GetMin", ContourAttributes_GetMin, METH_VARARGS},
    {"SetMax", ContourAttributes_SetMax, METH_VARARGS},
    {"GetMax", ContourAttributes_GetMax, METH_VARARGS},
    {"SetScaling", ContourAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", ContourAttributes_GetScaling, METH_VARARGS},
    {"SetWireframe", ContourAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", ContourAttributes_GetWireframe, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ContourAttributes_dealloc(PyObject *v)
{
   ContourAttributesObject *obj = (ContourAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ContourAttributes_compare(PyObject *v, PyObject *w)
{
    ContourAttributes *a = ((ContourAttributesObject *)v)->data;
    ContourAttributes *b = ((ContourAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ContourAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "changedColors") == 0)
        return ContourAttributes_GetChangedColors(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return ContourAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorBySingleColor));
    else if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorByMultipleColors));
    else if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return ContourAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return ContourAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return ContourAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return ContourAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return ContourAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "contourNLevels") == 0)
        return ContourAttributes_GetContourNLevels(self, NULL);
    if(strcmp(name, "contourValue") == 0)
        return ContourAttributes_GetContourValue(self, NULL);
    if(strcmp(name, "contourPercent") == 0)
        return ContourAttributes_GetContourPercent(self, NULL);
    if(strcmp(name, "contourMethod") == 0)
        return ContourAttributes_GetContourMethod(self, NULL);
    if(strcmp(name, "Level") == 0)
        return PyInt_FromLong(long(ContourAttributes::Level));
    else if(strcmp(name, "Value") == 0)
        return PyInt_FromLong(long(ContourAttributes::Value));
    else if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(ContourAttributes::Percent));

    if(strcmp(name, "minFlag") == 0)
        return ContourAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return ContourAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return ContourAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return ContourAttributes_GetMax(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return ContourAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ContourAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ContourAttributes::Log));

    if(strcmp(name, "wireframe") == 0)
        return ContourAttributes_GetWireframe(self, NULL);

    return Py_FindMethod(ContourAttributes_methods, self, name);
}

static int
ContourAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "changedColors") == 0)
        retval = (ContourAttributes_SetChangedColors(self, tuple) != NULL);
    else if(strcmp(name, "colorType") == 0)
        retval = (ContourAttributes_SetColorType(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (ContourAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (ContourAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (ContourAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (ContourAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (ContourAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "contourNLevels") == 0)
        retval = (ContourAttributes_SetContourNLevels(self, tuple) != NULL);
    else if(strcmp(name, "contourValue") == 0)
        retval = (ContourAttributes_SetContourValue(self, tuple) != NULL);
    else if(strcmp(name, "contourPercent") == 0)
        retval = (ContourAttributes_SetContourPercent(self, tuple) != NULL);
    else if(strcmp(name, "contourMethod") == 0)
        retval = (ContourAttributes_SetContourMethod(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (ContourAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (ContourAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (ContourAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (ContourAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "scaling") == 0)
        retval = (ContourAttributes_SetScaling(self, tuple) != NULL);
    else if(strcmp(name, "wireframe") == 0)
        retval = (ContourAttributes_SetWireframe(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ContourAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)v;

    //defaultPalette
    {   const unsignedCharVector &changedColors = obj->data->GetChangedColors();
        fprintf(fp, "changedColors = (");
        for(int i = 0; i < changedColors.size(); ++i)
        {
            fprintf(fp, "%d", int(changedColors[i]));
            if(i < changedColors.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(obj->data->GetColorType() == ContourAttributes::ColorBySingleColor)
        fprintf(fp, "colorType = ColorBySingleColor  # %s\n", colorType_names);
    else if(obj->data->GetColorType() == ContourAttributes::ColorByMultipleColors)
        fprintf(fp, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
    else
        fprintf(fp, "colorType = ColorByColorTable  # %s\n", colorType_names);

    fprintf(fp, "colorTableName = \"%s\"\n", obj->data->GetColorTableName().c_str());
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    //multiColor
    fprintf(fp, "contourNLevels = %d\n", obj->data->GetContourNLevels());
    {   const doubleVector &contourValue = obj->data->GetContourValue();
        fprintf(fp, "contourValue = (");
        for(int i = 0; i < contourValue.size(); ++i)
        {
            fprintf(fp, "%g", contourValue[i]);
            if(i < contourValue.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const doubleVector &contourPercent = obj->data->GetContourPercent();
        fprintf(fp, "contourPercent = (");
        for(int i = 0; i < contourPercent.size(); ++i)
        {
            fprintf(fp, "%g", contourPercent[i]);
            if(i < contourPercent.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *contourMethod_names = "Level, Value, Percent";
    if(obj->data->GetContourMethod() == ContourAttributes::Level)
        fprintf(fp, "contourMethod = Level  # %s\n", contourMethod_names);
    else if(obj->data->GetContourMethod() == ContourAttributes::Value)
        fprintf(fp, "contourMethod = Value  # %s\n", contourMethod_names);
    else
        fprintf(fp, "contourMethod = Percent  # %s\n", contourMethod_names);

    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    fprintf(fp, "min = %g\n", obj->data->GetMin());
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    const char *scaling_names = "Linear, Log";
    if(obj->data->GetScaling() == ContourAttributes::Linear)
        fprintf(fp, "scaling = Linear  # %s\n", scaling_names);
    else
        fprintf(fp, "scaling = Log  # %s\n", scaling_names);

    if(obj->data->GetWireframe())
        fprintf(fp, "wireframe = 1\n");
    else
        fprintf(fp, "wireframe = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyContourAttributes_StringRepresentation(const ContourAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

#if 0
// Ifdef this code out until all attributes have Python StringRepresentation methods
    { // new scope
         PyObject *obj = PyColorControlPointList_StringRepresentation(atts->GetDefaultPalette());
         str += "defaultPalette = {";
         if(obj != 0) str += PyString_AS_STRING(obj);
         str += "}\n";
    }
#endif
    {   const unsignedCharVector &changedColors = atts->GetChangedColors();
        SNPRINTF(tmpStr, 1000, "changedColors = (");
        str += tmpStr;
        for(int i = 0; i < changedColors.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(changedColors[i]));
            str += tmpStr;
            if(i < changedColors.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(atts->GetColorType() == ContourAttributes::ColorBySingleColor)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorBySingleColor  # %s\n", colorType_names);
             str += tmpStr;
        }
    else if(atts->GetColorType() == ContourAttributes::ColorByMultipleColors)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByColorTable  # %s\n", colorType_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "colorTableName = \"%s\"\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
#if 0
// Ifdef this code out until all attributes have Python StringRepresentation methods
    { // new scope
         PyObject *obj = PyColorAttributeList_StringRepresentation(atts->GetMultiColor());
         str += "multiColor = {";
         if(obj != 0) str += PyString_AS_STRING(obj);
         str += "}\n";
    }
#endif
    SNPRINTF(tmpStr, 1000, "contourNLevels = %d\n", atts->GetContourNLevels());
    str += tmpStr;
    {   const doubleVector &contourValue = atts->GetContourValue();
        SNPRINTF(tmpStr, 1000, "contourValue = (");
        str += tmpStr;
        for(int i = 0; i < contourValue.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", contourValue[i]);
            str += tmpStr;
            if(i < contourValue.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &contourPercent = atts->GetContourPercent();
        SNPRINTF(tmpStr, 1000, "contourPercent = (");
        str += tmpStr;
        for(int i = 0; i < contourPercent.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", contourPercent[i]);
            str += tmpStr;
            if(i < contourPercent.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *contourMethod_names = "Level, Value, Percent";
    if(atts->GetContourMethod() == ContourAttributes::Level)
        {
             SNPRINTF(tmpStr, 1000, "contourMethod = Level  # %s\n", contourMethod_names);
             str += tmpStr;
        }
    else if(atts->GetContourMethod() == ContourAttributes::Value)
        {
             SNPRINTF(tmpStr, 1000, "contourMethod = Value  # %s\n", contourMethod_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "contourMethod = Percent  # %s\n", contourMethod_names);
             str += tmpStr;
        }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "minFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "minFlag = 0\n");
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "maxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "min = %g\n", atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "max = %g\n", atts->GetMax());
    str += tmpStr;
    const char *scaling_names = "Linear, Log";
    if(atts->GetScaling() == ContourAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "scaling = Linear  # %s\n", scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "scaling = Log  # %s\n", scaling_names);
             str += tmpStr;
        }

    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "wireframe = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "wireframe = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
ContourAttributes_str(PyObject *v)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)v;
    return PyContourAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *ContourAttributes_Purpose = "This class contains the plot attributes for the contour plot.";

//
// The type description structure
//
static PyTypeObject ContourAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ContourAttributes",                    // tp_name
    sizeof(ContourAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ContourAttributes_dealloc,  // tp_dealloc
    (printfunc)ContourAttributes_print,     // tp_print
    (getattrfunc)ContourAttributes_getattr, // tp_getattr
    (setattrfunc)ContourAttributes_setattr, // tp_setattr
    (cmpfunc)ContourAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ContourAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ContourAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ContourAttributes *defaultAtts = 0;

static PyObject *
NewContourAttributes()
{
    ContourAttributesObject *newObject;
    newObject = PyObject_NEW(ContourAttributesObject, &ContourAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ContourAttributes(*defaultAtts);
    else
        newObject->data = new ContourAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapContourAttributes(const ContourAttributes *attr)
{
    ContourAttributesObject *newObject;
    newObject = PyObject_NEW(ContourAttributesObject, &ContourAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ContourAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ContourAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewContourAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ContourAttributesMethods[] = {
    {"ContourAttributes", ContourAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ContourAttributesObserver = 0;
static bool ContourAttributesEnableLogging = true;

static void
PyContourAttributes_WriteLog(Subject *subj, void *data)
{
    ContourAttributes *atts = (ContourAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ContourAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ContourAttributes_WriteLog()\n");
}

void
PyContourAttributes_StartUp(ContourAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyContourAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ContourAttributesObserver == 0)
    {
        ContourAttributesObserver = new ObserverToCallback(subj,
            PyContourAttributes_WriteLog, (void *)logFile);
    }

    ContourAttributesEnableLogging = true;
}

void
PyContourAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ContourAttributesObserver;
    ContourAttributesObserver = 0;
}

PyMethodDef *
PyContourAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ContourAttributesMethods;
}

bool
PyContourAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ContourAttributesType);
}

ContourAttributes *
PyContourAttributes_FromPyObject(PyObject *obj)
{
    ContourAttributesObject *obj2 = (ContourAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyContourAttributes_NewPyObject()
{
    return NewContourAttributes();
}

PyObject *
PyContourAttributes_WrapPyObject(const ContourAttributes *attr)
{
    return WrapContourAttributes(attr);
}

void
PyContourAttributes_SetLogging(bool val)
{
    ContourAttributesEnableLogging = val;
}

void
PyContourAttributes_SetDefaults(const ContourAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ContourAttributes(*atts);
}

