// ************************************************************************* //
//  File: ContourViewerPluginInfo.C
// ************************************************************************* //

#include <ContourPluginInfo.h>
#include <avtContourPlot.h>
#include <avtColorTables.h>
#include <ColorTableAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Contour_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Contour plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    ContourViewerPluginInfo::InitializeGlobalObjects();
    return new ContourViewerPluginInfo;
}

//
// Storage for static data elements.
//
ContourAttributes *ContourViewerPluginInfo::clientAtts = NULL;
ContourAttributes *ContourViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ContourViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************
void
ContourViewerPluginInfo::InitializeGlobalObjects()
{
    ContourViewerPluginInfo::clientAtts  = new ContourAttributes;
    ContourViewerPluginInfo::defaultAtts = new ContourAttributes;

    InitializeDefaultPalette(clientAtts);
    InitializeDefaultPalette(defaultAtts);
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

AttributeSubject *
ContourViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

AttributeSubject *
ContourViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

void
ContourViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ContourAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

void
ContourViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ContourAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

avtPlot *
ContourViewerPluginInfo::AllocAvtPlot()
{
    return new avtContourPlot;
}

// ****************************************************************************
//  Method: ContourViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
//  Modifications:
//    Brad Whitlock, Fri Nov 22 14:06:17 PST 2002
//    Copy over the new plot's defaultPalette with the active discrete
//    palette from avtColorTables.
//
//    Brad Whitlock, Fri Mar 26 15:26:25 PST 2004
//    Changed the method interface.
//
// ****************************************************************************

void
ContourViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    ContourAttributes *contour = (ContourAttributes *)atts;
    *contour = *defaultAtts;

    // Set the defaultPalette for the plot.
    InitializeDefaultPalette(contour);
}

// ****************************************************************************
// Method: ContourViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
ContourViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}


// ****************************************************************************
//  Method: ContourViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:28 PST 2004
//
// ****************************************************************************

#include <Contour.xpm>
const char **
ContourViewerPluginInfo::XPMIconData() const
{
    return Contour_xpm;
}

// ****************************************************************************
// Method: ContourViewerPluginInfo::InitializeDefaultPalette
//
// Purpose: 
//   Initializes the default palette in the contour attributes using the
//   default discrete color table.
//
// Arguments:
//   contour : The ContourAttributes to initialize.
//
// Programmer: Brad Whitlock
// Creation:   Mon Dec 9 13:12:27 PST 2002
//
// Modifications:
//   Brad Whitlock, Wed Oct 22 16:42:08 PST 2003
//   I changed the code so if we're in multicolor mode, the default palette
//   does not get overwritten unless it is empty.
//
// ****************************************************************************

void
ContourViewerPluginInfo::InitializeDefaultPalette(ContourAttributes *contour)
{
    // Copy over the contour's defaultPalette with the default discrete
    // color table from avtColorTable.
    if(contour->GetColorType() != ContourAttributes::ColorByMultipleColors ||
       contour->GetDefaultPalette().GetNumColorControlPoints() < 1)
    {
        avtColorTables *ct = avtColorTables::Instance();
        ColorTableAttributes *ctAtts = ct->GetColorTables();
        int i = ctAtts->GetColorTableIndex(ct->GetDefaultDiscreteColorTable());
        if(i != -1)
        {
            contour->SetDefaultPalette(ctAtts->operator[](i));
        }
    }
}
