// ************************************************************************* //
//                        ContourScriptingPluginInfo.C
// ************************************************************************* //
#include <ContourPluginInfo.h>
#include <PyContourAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Contour_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Contour plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new ContourScriptingPluginInfo;
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ContourScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyContourAttributes_StartUp((ContourAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ContourScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyContourAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Contour plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ContourScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyContourAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ContourScriptingPluginInfo::SetLogging(bool val)
{
    PyContourAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ContourScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ContourScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyContourAttributes_SetDefaults((const ContourAttributes *)atts);
}
