#include <PyBoundaryAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyBoundaryAttributes
//
// Purpose: 
//   This class contains the plot attributes for the boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 12 10:15:06 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a BoundaryAttributes.
//
struct BoundaryAttributesObject
{
    PyObject_HEAD
    BoundaryAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewBoundaryAttributes();

static PyObject *
BoundaryAttributes_Notify(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_SetColorType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(BoundaryAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetColorType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
BoundaryAttributes_SetFilledFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the filledFlag in the object.
    obj->data->SetFilledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetFilledFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFilledFlag()?1L:0L);
    return retval;
}

static PyObject *
BoundaryAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
BoundaryAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
BoundaryAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
BoundaryAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(int i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetBoundaryType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundaryType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetBoundaryType(BoundaryAttributes::Boundary_Type(ival));
    else
    {
        fprintf(stderr, "An invalid boundaryType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Domain, Group, Material, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetBoundaryType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundaryType()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

static PyObject *
BoundaryAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

static PyObject *
BoundaryAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
BoundaryAttributes_SetPointType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(BoundaryAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetPointType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
BoundaryAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

static PyObject *
BoundaryAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
BoundaryAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}



static struct PyMethodDef BoundaryAttributes_methods[] = {
    {"Notify", BoundaryAttributes_Notify, METH_VARARGS},
    {"SetColorType", BoundaryAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", BoundaryAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", BoundaryAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", BoundaryAttributes_GetColorTableName, METH_VARARGS},
    {"SetFilledFlag", BoundaryAttributes_SetFilledFlag, METH_VARARGS},
    {"GetFilledFlag", BoundaryAttributes_GetFilledFlag, METH_VARARGS},
    {"SetLegendFlag", BoundaryAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", BoundaryAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", BoundaryAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", BoundaryAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", BoundaryAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", BoundaryAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", BoundaryAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", BoundaryAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", BoundaryAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", BoundaryAttributes_GetMultiColor, METH_VARARGS},
    {"SetBoundaryNames", BoundaryAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", BoundaryAttributes_GetBoundaryNames, METH_VARARGS},
    {"SetBoundaryType", BoundaryAttributes_SetBoundaryType, METH_VARARGS},
    {"GetBoundaryType", BoundaryAttributes_GetBoundaryType, METH_VARARGS},
    {"SetOpacity", BoundaryAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", BoundaryAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", BoundaryAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", BoundaryAttributes_GetWireframe, METH_VARARGS},
    {"SetSmoothingLevel", BoundaryAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", BoundaryAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSize", BoundaryAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", BoundaryAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", BoundaryAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", BoundaryAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", BoundaryAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", BoundaryAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", BoundaryAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", BoundaryAttributes_GetPointSizeVar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
BoundaryAttributes_dealloc(PyObject *v)
{
   BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
BoundaryAttributes_compare(PyObject *v, PyObject *w)
{
    BoundaryAttributes *a = ((BoundaryAttributesObject *)v)->data;
    BoundaryAttributes *b = ((BoundaryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
BoundaryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return BoundaryAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorBySingleColor));
    else if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorByMultipleColors));
    else if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return BoundaryAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "filledFlag") == 0)
        return BoundaryAttributes_GetFilledFlag(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return BoundaryAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return BoundaryAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return BoundaryAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return BoundaryAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return BoundaryAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "boundaryType") == 0)
        return BoundaryAttributes_GetBoundaryType(self, NULL);
    if(strcmp(name, "Domain") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Domain));
    else if(strcmp(name, "Group") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Group));
    else if(strcmp(name, "Material") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Material));
    else if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Unknown));

    if(strcmp(name, "opacity") == 0)
        return BoundaryAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return BoundaryAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return BoundaryAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return BoundaryAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return BoundaryAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::Point));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return BoundaryAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return BoundaryAttributes_GetPointSizeVar(self, NULL);

    return Py_FindMethod(BoundaryAttributes_methods, self, name);
}

static int
BoundaryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "colorType") == 0)
        retval = (BoundaryAttributes_SetColorType(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (BoundaryAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "filledFlag") == 0)
        retval = (BoundaryAttributes_SetFilledFlag(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (BoundaryAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (BoundaryAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (BoundaryAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (BoundaryAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "boundaryNames") == 0)
        retval = (BoundaryAttributes_SetBoundaryNames(self, tuple) != NULL);
    else if(strcmp(name, "boundaryType") == 0)
        retval = (BoundaryAttributes_SetBoundaryType(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (BoundaryAttributes_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "wireframe") == 0)
        retval = (BoundaryAttributes_SetWireframe(self, tuple) != NULL);
    else if(strcmp(name, "smoothingLevel") == 0)
        retval = (BoundaryAttributes_SetSmoothingLevel(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (BoundaryAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (BoundaryAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        retval = (BoundaryAttributes_SetPointSizeVarEnabled(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVar") == 0)
        retval = (BoundaryAttributes_SetPointSizeVar(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
BoundaryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(obj->data->GetColorType() == BoundaryAttributes::ColorBySingleColor)
        fprintf(fp, "colorType = ColorBySingleColor  # %s\n", colorType_names);
    else if(obj->data->GetColorType() == BoundaryAttributes::ColorByMultipleColors)
        fprintf(fp, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
    else
        fprintf(fp, "colorType = ColorByColorTable  # %s\n", colorType_names);

    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    if(obj->data->GetFilledFlag())
        fprintf(fp, "filledFlag = 1\n");
    else
        fprintf(fp, "filledFlag = 0\n");
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    //multiColor
    {   const stringVector &boundaryNames = obj->data->GetBoundaryNames();
        fprintf(fp, "boundaryNames = (");
        for(int i = 0; i < boundaryNames.size(); ++i)
        {
            fprintf(fp, "\"%s\"", boundaryNames[i].c_str());
            if(i < boundaryNames.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *boundaryType_names = "Domain, Group, Material, Unknown";
    if(obj->data->GetBoundaryType() == BoundaryAttributes::Domain)
        fprintf(fp, "boundaryType = Domain  # %s\n", boundaryType_names);
    else if(obj->data->GetBoundaryType() == BoundaryAttributes::Group)
        fprintf(fp, "boundaryType = Group  # %s\n", boundaryType_names);
    else if(obj->data->GetBoundaryType() == BoundaryAttributes::Material)
        fprintf(fp, "boundaryType = Material  # %s\n", boundaryType_names);
    else
        fprintf(fp, "boundaryType = Unknown  # %s\n", boundaryType_names);

    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());
    if(obj->data->GetWireframe())
        fprintf(fp, "wireframe = 1\n");
    else
        fprintf(fp, "wireframe = 0\n");
    fprintf(fp, "smoothingLevel = %d\n", obj->data->GetSmoothingLevel());
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == BoundaryAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == BoundaryAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == BoundaryAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    if(obj->data->GetPointSizeVarEnabled())
        fprintf(fp, "pointSizeVarEnabled = 1\n");
    else
        fprintf(fp, "pointSizeVarEnabled = 0\n");
    fprintf(fp, "pointSizeVar = \"%s\"\n", obj->data->GetPointSizeVar().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyBoundaryAttributes_StringRepresentation(const BoundaryAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(atts->GetColorType() == BoundaryAttributes::ColorBySingleColor)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorBySingleColor  # %s\n", colorType_names);
             str += tmpStr;
        }
    else if(atts->GetColorType() == BoundaryAttributes::ColorByMultipleColors)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByColorTable  # %s\n", colorType_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    if(atts->GetFilledFlag())
        SNPRINTF(tmpStr, 1000, "filledFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "filledFlag = 0\n");
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
#if 0
    { // new scope
         PyObject *s = PyColorAttributeList_StringRepresentation(atts->GetMultiColor());
         str += "multiColor = {"
         if(obj != 0) str += PyString_AS_STRING(s);
         str += "}"
    }
#endif
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        SNPRINTF(tmpStr, 1000, "boundaryNames = (");
        str += tmpStr;
        for(int i = 0; i < boundaryNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *boundaryType_names = "Domain, Group, Material, Unknown";
    if(atts->GetBoundaryType() == BoundaryAttributes::Domain)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Domain  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else if(atts->GetBoundaryType() == BoundaryAttributes::Group)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Group  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else if(atts->GetBoundaryType() == BoundaryAttributes::Material)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Material  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Unknown  # %s\n", boundaryType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "opacity = %g\n", atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "wireframe = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "wireframe = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "smoothingLevel = %d\n", atts->GetSmoothingLevel());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == BoundaryAttributes::Box)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == BoundaryAttributes::Axis)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == BoundaryAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSizeVar = \"%s\"\n", atts->GetPointSizeVar().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
BoundaryAttributes_str(PyObject *v)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;
    return PyBoundaryAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *BoundaryAttributes_Purpose = "This class contains the plot attributes for the boundary plot.";

//
// The type description structure
//
static PyTypeObject BoundaryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "BoundaryAttributes",                    // tp_name
    sizeof(BoundaryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)BoundaryAttributes_dealloc,  // tp_dealloc
    (printfunc)BoundaryAttributes_print,     // tp_print
    (getattrfunc)BoundaryAttributes_getattr, // tp_getattr
    (setattrfunc)BoundaryAttributes_setattr, // tp_setattr
    (cmpfunc)BoundaryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)BoundaryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    BoundaryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static BoundaryAttributes *defaultAtts = 0;

static PyObject *
NewBoundaryAttributes()
{
    BoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryAttributesObject, &BoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new BoundaryAttributes(*defaultAtts);
    else
        newObject->data = new BoundaryAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapBoundaryAttributes(const BoundaryAttributes *attr)
{
    BoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryAttributesObject, &BoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (BoundaryAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
BoundaryAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewBoundaryAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef BoundaryAttributesMethods[] = {
    {"BoundaryAttributes", BoundaryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *BoundaryAttributesObserver = 0;
static bool BoundaryAttributesEnableLogging = true;

static void
PyBoundaryAttributes_WriteLog(Subject *subj, void *data)
{
    BoundaryAttributes *atts = (BoundaryAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!BoundaryAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# BoundaryAttributes_WriteLog()\n");
}

void
PyBoundaryAttributes_StartUp(BoundaryAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyBoundaryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(BoundaryAttributesObserver == 0)
    {
        BoundaryAttributesObserver = new ObserverToCallback(subj,
            PyBoundaryAttributes_WriteLog, (void *)logFile);
    }

    BoundaryAttributesEnableLogging = true;
}

void
PyBoundaryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete BoundaryAttributesObserver;
    BoundaryAttributesObserver = 0;
}

PyMethodDef *
PyBoundaryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return BoundaryAttributesMethods;
}

bool
PyBoundaryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &BoundaryAttributesType);
}

BoundaryAttributes *
PyBoundaryAttributes_FromPyObject(PyObject *obj)
{
    BoundaryAttributesObject *obj2 = (BoundaryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyBoundaryAttributes_NewPyObject()
{
    return NewBoundaryAttributes();
}

PyObject *
PyBoundaryAttributes_WrapPyObject(const BoundaryAttributes *attr)
{
    return WrapBoundaryAttributes(attr);
}

void
PyBoundaryAttributes_SetLogging(bool val)
{
    BoundaryAttributesEnableLogging = val;
}


// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Jul 18 13:49:42 PDT 2003 
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************

void
PyBoundaryAttributes_SetDefaults(const BoundaryAttributes *atts)
{
    defaultAtts = const_cast<BoundaryAttributes*>(atts);
}
