// ************************************************************************* //
//  File: BoundaryViewerPluginInfo.C
// ************************************************************************* //

#include <BoundaryPluginInfo.h>

#if defined(__APPLE__)
#define GetViewerInfo Boundary_GetViewerInfo
#endif

#include <stdio.h>

#include <avtColorTables.h>
#include <avtDatabaseMetaData.h>
#include <avtBoundaryPlot.h>
#include <avtTypes.h>
#include <set>

#include <DebugStream.h>
#include <InvalidVariableException.h>

using std::string;
using std::set;

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Boundary plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    BoundaryViewerPluginInfo::InitializeGlobalObjects();
    return new BoundaryViewerPluginInfo;
}

//
// Storage for static data elements.
//
BoundaryAttributes *BoundaryViewerPluginInfo::clientAtts = NULL;
BoundaryAttributes *BoundaryViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  BoundaryViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************
void
BoundaryViewerPluginInfo::InitializeGlobalObjects()
{
    BoundaryViewerPluginInfo::clientAtts  = new BoundaryAttributes;
    BoundaryViewerPluginInfo::defaultAtts = new BoundaryAttributes;
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

AttributeSubject *
BoundaryViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

AttributeSubject *
BoundaryViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(BoundaryAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(BoundaryAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

avtPlot *
BoundaryViewerPluginInfo::AllocAvtPlot()
{
    return new avtBoundaryPlot;
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
//  Modifications:
//    Kathleen Bonnell, Tue Nov  6 08:19:45 PST 2001
//    Create labels only from mesh related to varName, not from all
//    meshes.
//
//    Hank Childs, Wed Aug 14 11:30:18 PDT 2002
//    Only use the labels from the material we actually have.
//
//    Kathleen Bonnell, Thu Sep  5 10:55:47 PDT 2002  
//    Moved bulk of code to PrivateSetPlotAtts to aid in maintenance, as it is
//    shared with ResetPlotAtts. 
//
//    Brad Whitlock, Fri Mar 26 15:15:38 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)
{
    *(BoundaryAttributes*)atts = *defaultAtts;

    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::ResetPlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Sep 7 10:53:06 PDT 2001
//
//  Modifications:
//    Kathleen Bonnell, Mon Apr 29 13:37:14 PDT 2002  
//    Create labels only from mesh related to varName, not from all
//    meshes.
//
//    Hank Childs, Wed Aug 14 11:30:18 PDT 2002
//    Only use the labels from the material we actually have.
//
//    Kathleen Bonnell, Thu Sep  5 10:55:47 PDT 2002  
//    Moved code to PrivateSetPlotAtts to aid in maintenance, as the code is
//    shared with InitializePlotAtts. 
//
//    Brad Whitlock, Fri Mar 26 15:15:38 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::ResetPlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)
{
    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::PrivateSetPlotAtts
//
//  Purpose:
//    Initialize the plot attributes. 
//
//  Arguments:
//    atts          The attribute subject to initialize.
//    hostName      The host name of the plot. 
//    databaseName  The database name of the plot.
//    varName       The variable name of the plot.
//
//  Notes:  
//    This code was pulled from ResetPlotAtts and InitializePlotAtts to
//    aid in maintenance, and reworkd to support groups.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   September 5, 2002 
//
//  Modifications:
//    Kathleen Bonnell, Thu Dec  5 16:53:22 PST 2002 
//    Changed exception from ImproperUse to InvalidVariable.
//
//    Brad Whitlock, Wed Nov 20 14:12:03 PST 2002
//    I added support for discrete color tables.
//
//    Kathleen Bonnell, Thu Sep  4 16:08:46 PDT 2003 
//    Set colors, subsetNames for defaultAtts so that "Reset" won't zero
//    out the colors in the gui.
//
//    Brad Whitlock, Fri Mar 26 15:15:38 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::PrivateSetPlotAtts(AttributeSubject *atts, 
    const avtDatabaseMetaData *md, const char *varName)
{
    BoundaryAttributes *boundaryAtts = (BoundaryAttributes *)atts;

    //
    // Get the meta-data and initialize the boundary names and colors in the
    // new BoundaryAttributes object.
    //
    if (md == NULL)
    {
        return;
    }

    avtDatabaseMetaData *nonConstmd = const_cast <avtDatabaseMetaData *>(md);

    string vn(varName);

    const avtMaterialMetaData *mat = NULL;

    string meshName = nonConstmd->MeshForVar(varName);
    avtMeshMetaData *mesh = 
        const_cast <avtMeshMetaData *> (md->GetMesh(meshName));


    stringVector       sv;
    stringVector::const_iterator pos;
    set<int> groupSet;
    vector<int> gIDS;
    int i;
    char temp[512];

    // 
    // Create boundary names, based on Boundary Type 
    // 
    avtSubsetType subT = nonConstmd->DetermineSubsetType(vn);
    switch (subT)
    {
      case AVT_DOMAIN_SUBSET : 
          debug5 << "Variable for boundary plot is a domain Mesh." << endl; 
          boundaryAtts->SetBoundaryType(BoundaryAttributes::Domain);
          defaultAtts->SetBoundaryType(BoundaryAttributes::Domain);
          if (mesh->blockNames.empty())
          {
              for (i = 0; i < mesh->numBlocks; i++)
              { 
                  sprintf(temp, "%d", i+mesh->blockOrigin);
                  sv.push_back(temp);
              }
          }
          else
          {
              for(pos = mesh->blockNames.begin();
                  pos != mesh->blockNames.end(); ++pos)
              {
                  sv.push_back(*pos);
              }
          }
          break;

      case AVT_GROUP_SUBSET :
          debug5 << "Variable for boundary plot is a group Mesh." << endl; 
          boundaryAtts->SetBoundaryType(BoundaryAttributes::Group);
          defaultAtts->SetBoundaryType(BoundaryAttributes::Group);
          for (i = 0; i < mesh->groupIds.size(); i++)
          {
              if (groupSet.count(mesh->groupIds[i]) == 0)
              {
                  groupSet.insert(mesh->groupIds[i]);
                  gIDS.push_back(mesh->groupIds[i]);
              }
          }
          for (i = 0; i < gIDS.size(); i++)
          {
              sprintf(temp, "%d", gIDS[i]);
              sv.push_back(temp);
          }
          break;

      case AVT_MATERIAL_SUBSET :
          debug5 << "Variable for boundary plot is a Material." << endl; 
          boundaryAtts->SetBoundaryType(BoundaryAttributes::Material);
          defaultAtts->SetBoundaryType(BoundaryAttributes::Material);
          mat = md->GetMaterial(vn);
          if (mat != NULL)
          {
              for(pos = mat->materialNames.begin();
                  pos != mat->materialNames.end(); ++pos)
              {
                  sv.push_back(*pos);
              }
          }
          break;

      default:
          EXCEPTION1(InvalidVariableException, varName);
          break;
    }
    
    // 
    // Add a color for each boundary name.
    //
    ColorAttribute *ca = new ColorAttribute[sv.size() + 1];
    avtColorTables *ct = avtColorTables::Instance();
    if(ct->IsDiscrete(ct->GetDefaultDiscreteColorTable()))
    {
        // The CT is discrete, get its color color control points.
        for(int i = 0; i < sv.size(); ++i)
        {
            unsigned char rgb[3] = {0,0,0};
            ct->GetControlPointColor(ct->GetDefaultDiscreteColorTable(), i, rgb);
            ca[i].SetRed(int(rgb[0]));
            ca[i].SetGreen(int(rgb[1]));
            ca[i].SetBlue(int(rgb[2]));
        }
    }
    else
    {
        // The CT is continuous, sample the CT so we have a unique color
        // for each element in sv.
        unsigned char *rgb = ct->GetSampledColors(
            ct->GetDefaultDiscreteColorTable(), sv.size());
        if(rgb)
        {
            for(int i = 0; i < sv.size(); ++i)
            {
                ca[i].SetRed(int(rgb[i*3]));
                ca[i].SetGreen(int(rgb[i*3+1]));
                ca[i].SetBlue(int(rgb[i*3+2]));
            }
            delete [] rgb;
        }
    }

    ColorAttributeList cal;
    int idx = 0;
    for(pos = sv.begin(); pos != sv.end(); ++pos)
    {
        if (idx < boundaryAtts->GetMultiColor().GetNumColorAttributes())
        {
            // The meshIndex is within the defaultAtts' color
            // vector size.
            cal.AddColorAttribute(boundaryAtts->GetMultiColor()[idx]);
        }
        else
        {
            // The meshIndex is greater than the size of the
            // defaultAtts' color vector. Use colors from the
            // default discrete color table.
            cal.AddColorAttribute(ca[idx]);
        }
        ++idx;
    }

    delete [] ca;

    // Set the boundary names and colors in the boundaryAtts.
    boundaryAtts->SetBoundaryNames(sv);
    boundaryAtts->SetMultiColor(cal);
    defaultAtts->SetBoundaryNames(sv);
    defaultAtts->SetMultiColor(cal);
}

// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   December 5, 2002 
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:15:38 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
BoundaryViewerPluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)
{
    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
// Method: BoundaryViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
BoundaryViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SUBSET;
}


// ****************************************************************************
//  Method: BoundaryViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************

#include <Boundary.xpm>
const char **
BoundaryViewerPluginInfo::XPMIconData() const
{
    return Boundary_xpm;
}
