// ************************************************************************* //
//                        BoundaryScriptingPluginInfo.C
// ************************************************************************* //
#include <BoundaryPluginInfo.h>
#include <PyBoundaryAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Boundary_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Boundary plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new BoundaryScriptingPluginInfo;
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoundaryScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyBoundaryAttributes_StartUp((BoundaryAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
BoundaryScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyBoundaryAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Boundary plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyBoundaryAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoundaryScriptingPluginInfo::SetLogging(bool val)
{
    PyBoundaryAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: BoundaryScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Wed May 7 01:03:30 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
BoundaryScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyBoundaryAttributes_SetDefaults((const BoundaryAttributes *)atts);
}
