// ************************************************************************* //
//  File: BoundaryGUIPluginInfo.C
// ************************************************************************* //

#include <BoundaryPluginInfo.h>
#include <BoundaryAttributes.h>
#include <QvisBoundaryPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Boundary_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Boundary plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:08 PST 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new BoundaryGUIPluginInfo;
}

// ****************************************************************************
//  Method: BoundaryGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:08 PST 2004
//
// ****************************************************************************

const char *
BoundaryGUIPluginInfo::GetMenuName() const
{
    return "Boundary";
}


// ****************************************************************************
// Method: BoundaryGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
BoundaryGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MATERIAL;
}

// ****************************************************************************
//  Method: BoundaryGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:08 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
BoundaryGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisBoundaryPlotWindow(type, (BoundaryAttributes *)attr,
        "Boundary plot attributes", "Boundary plot", notepad);
}

// ****************************************************************************
//  Method: BoundaryGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:08 PST 2004
//
// ****************************************************************************

#include <Boundary.xpm>
const char **
BoundaryGUIPluginInfo::XPMIconData() const
{
    return Boundary_xpm;
}
