// ************************************************************************* //
//  File: TubeViewerPluginInfo.C
// ************************************************************************* //

#include <TubePluginInfo.h>
#include <TubeAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Tube_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Tube operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    TubeViewerPluginInfo::InitializeGlobalObjects();
    return new TubeViewerPluginInfo;
}

//
// Storage for static data elements.
//
TubeAttributes *TubeViewerPluginInfo::clientAtts = NULL;
TubeAttributes *TubeViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TubeViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************
void
TubeViewerPluginInfo::InitializeGlobalObjects()
{
    TubeViewerPluginInfo::clientAtts  = new TubeAttributes;
    TubeViewerPluginInfo::defaultAtts = new TubeAttributes;
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

AttributeSubject *
TubeViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

AttributeSubject *
TubeViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

void
TubeViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TubeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

void
TubeViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TubeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

void
TubeViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(TubeAttributes*)atts = *defaultAtts;
    else
        *(TubeAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TubeViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:21 PST 2003
//
// ****************************************************************************

#include <Tube.xpm>
const char **
TubeViewerPluginInfo::XPMIconData() const
{
    return Tube_xpm;
}
