// ************************************************************************* //
//                        TubeScriptingPluginInfo.C
// ************************************************************************* //
#include <TubePluginInfo.h>
#include <PyTubeAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Tube_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Tube plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new TubeScriptingPluginInfo;
}

// ****************************************************************************
// Method: TubeScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TubeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyTubeAttributes_StartUp((TubeAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: TubeScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
TubeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTubeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TubeScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Tube plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
TubeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTubeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TubeScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TubeScriptingPluginInfo::SetLogging(bool val)
{
    PyTubeAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: TubeScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:15 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TubeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTubeAttributes_SetDefaults((const TubeAttributes *)atts);
}
