// ************************************************************************* //
//  File: TubeGUIPluginInfo.C
// ************************************************************************* //

#include <TubePluginInfo.h>
#include <TubeAttributes.h>
#include <QvisTubeWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Tube_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Tube operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Apr 7 13:46:35 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new TubeGUIPluginInfo;
}

// ****************************************************************************
//  Method: TubeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Apr 7 13:46:35 PST 2003
//
// ****************************************************************************

const char *
TubeGUIPluginInfo::GetMenuName() const
{
    return "Tube";
}


// ****************************************************************************
//  Method: TubeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Apr 7 13:46:35 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
TubeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisTubeWindow(type, (TubeAttributes *)attr,
        "Tube operator attributes", "Tube operator", notepad);
}

// ****************************************************************************
//  Method: TubeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Apr 7 13:46:35 PST 2003
//
// ****************************************************************************

#include <Tube.xpm>
const char **
TubeGUIPluginInfo::XPMIconData() const
{
    return Tube_xpm;
}
