package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: TubeAttributes
//
// Purpose:
//    This class contains attributes for the tube operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:36 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class TubeAttributes extends AttributeSubject implements Plugin
{
    public TubeAttributes()
    {
        super(3);

        width = 0.5f;
        fineness = 3;
        capping = false;
    }

    public TubeAttributes(TubeAttributes obj)
    {
        super(3);

        width = obj.width;
        fineness = obj.fineness;
        capping = obj.capping;

        SelectAll();
    }

    public boolean equals(TubeAttributes obj)
    {
        // Create the return value
        return ((width == obj.width) &&
                (fineness == obj.fineness) &&
                (capping == obj.capping));
    }

    public String GetName() { return "Tube"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetWidth(float width_)
    {
        width = width_;
        Select(0);
    }

    public void SetFineness(int fineness_)
    {
        fineness = fineness_;
        Select(1);
    }

    public void SetCapping(boolean capping_)
    {
        capping = capping_;
        Select(2);
    }

    // Property getting methods
    public float   GetWidth() { return width; }
    public int     GetFineness() { return fineness; }
    public boolean GetCapping() { return capping; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteFloat(width);
        if(WriteSelect(1, buf))
            buf.WriteInt(fineness);
        if(WriteSelect(2, buf))
            buf.WriteBool(capping);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetWidth(buf.ReadFloat());
                break;
            case 1:
                SetFineness(buf.ReadInt());
                break;
            case 2:
                SetCapping(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private float   width;
    private int     fineness;
    private boolean capping;
}

