#include <PyTubeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTubeAttributes
//
// Purpose: 
//   This class contains attributes for the tube operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Oct 30 10:58:03 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a TubeAttributes.
//
struct TubeAttributesObject
{
    PyObject_HEAD
    TubeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewTubeAttributes();

static PyObject *
TubeAttributes_Notify(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TubeAttributes_SetWidth(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the width in the object.
    obj->data->SetWidth(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TubeAttributes_GetWidth(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetWidth()));
    return retval;
}

static PyObject *
TubeAttributes_SetFineness(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fineness in the object.
    obj->data->SetFineness(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TubeAttributes_GetFineness(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFineness()));
    return retval;
}

static PyObject *
TubeAttributes_SetCapping(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the capping in the object.
    obj->data->SetCapping(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TubeAttributes_GetCapping(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCapping()?1L:0L);
    return retval;
}



static struct PyMethodDef TubeAttributes_methods[] = {
    {"Notify", TubeAttributes_Notify, METH_VARARGS},
    {"SetWidth", TubeAttributes_SetWidth, METH_VARARGS},
    {"GetWidth", TubeAttributes_GetWidth, METH_VARARGS},
    {"SetFineness", TubeAttributes_SetFineness, METH_VARARGS},
    {"GetFineness", TubeAttributes_GetFineness, METH_VARARGS},
    {"SetCapping", TubeAttributes_SetCapping, METH_VARARGS},
    {"GetCapping", TubeAttributes_GetCapping, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TubeAttributes_dealloc(PyObject *v)
{
   TubeAttributesObject *obj = (TubeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
TubeAttributes_compare(PyObject *v, PyObject *w)
{
    TubeAttributes *a = ((TubeAttributesObject *)v)->data;
    TubeAttributes *b = ((TubeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
TubeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "width") == 0)
        return TubeAttributes_GetWidth(self, NULL);
    if(strcmp(name, "fineness") == 0)
        return TubeAttributes_GetFineness(self, NULL);
    if(strcmp(name, "capping") == 0)
        return TubeAttributes_GetCapping(self, NULL);

    return Py_FindMethod(TubeAttributes_methods, self, name);
}

static int
TubeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "width") == 0)
        retval = (TubeAttributes_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "fineness") == 0)
        retval = (TubeAttributes_SetFineness(self, tuple) != NULL);
    else if(strcmp(name, "capping") == 0)
        retval = (TubeAttributes_SetCapping(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
TubeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)v;

    fprintf(fp, "width = %g\n", obj->data->GetWidth());
    fprintf(fp, "fineness = %d\n", obj->data->GetFineness());
    if(obj->data->GetCapping())
        fprintf(fp, "capping = 1\n");
    else
        fprintf(fp, "capping = 0\n");

    return 0;
}

//
// The doc string for the class.
//
static char *TubeAttributes_Purpose = "This class contains attributes for the tube operator.";

//
// The type description structure
//
static PyTypeObject TubeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TubeAttributes",                    // tp_name
    sizeof(TubeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TubeAttributes_dealloc,  // tp_dealloc
    (printfunc)TubeAttributes_print,     // tp_print
    (getattrfunc)TubeAttributes_getattr, // tp_getattr
    (setattrfunc)TubeAttributes_setattr, // tp_setattr
    (cmpfunc)TubeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TubeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TubeAttributes *defaultAtts = 0;

static PyObject *
NewTubeAttributes()
{
    TubeAttributesObject *newObject;
    newObject = PyObject_NEW(TubeAttributesObject, &TubeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new TubeAttributes(*defaultAtts);
    else
        newObject->data = new TubeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapTubeAttributes(const TubeAttributes *attr)
{
    TubeAttributesObject *newObject;
    newObject = PyObject_NEW(TubeAttributesObject, &TubeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TubeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TubeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewTubeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TubeAttributesMethods[] = {
    {"TubeAttributes", TubeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TubeAttributesObserver = 0;
static bool TubeAttributesEnableLogging = true;

static void
PyTubeAttributes_WriteLog(Subject *subj, void *data)
{
    TubeAttributes *atts = (TubeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!TubeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# TubeAttributes_WriteLog()\n");
}

void
PyTubeAttributes_StartUp(TubeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyTubeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TubeAttributesObserver == 0)
    {
        TubeAttributesObserver = new ObserverToCallback(subj,
            PyTubeAttributes_WriteLog, (void *)logFile);
    }

    TubeAttributesEnableLogging = true;
}

void
PyTubeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TubeAttributesObserver;
    TubeAttributesObserver = 0;
}

PyMethodDef *
PyTubeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TubeAttributesMethods;
}

bool
PyTubeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TubeAttributesType);
}

TubeAttributes *
PyTubeAttributes_FromPyObject(PyObject *obj)
{
    TubeAttributesObject *obj2 = (TubeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTubeAttributes_NewPyObject()
{
    return NewTubeAttributes();
}

PyObject *
PyTubeAttributes_WrapPyObject(const TubeAttributes *attr)
{
    return WrapTubeAttributes(attr);
}

void
PyTubeAttributes_SetLogging(bool val)
{
    TubeAttributesEnableLogging = val;
}

void
PyTubeAttributes_SetDefaults(const TubeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TubeAttributes(*atts);
}

