// ************************************************************************* //
//  File: avtTransformFilter.C
// ************************************************************************* //

#include <avtTransformFilter.h>

#include <SimilarityTransformAttributes.h>

#include <avtSimilarityTransformFilter.h>
#include <avtCoordSystemConvert.h>

// ****************************************************************************
//  Method: avtTransformFilter constructor
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Initialize invM.
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Reflect that this filter is now a facaded filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Added coord system convert.
//
// ****************************************************************************

avtTransformFilter::avtTransformFilter()
{
    stf = new avtSimilarityTransformFilter();
    csc = new avtCoordSystemConvert();
}


// ****************************************************************************
//  Method: avtTransformFilter destructor
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Delete invM.
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Reflect that this filter is now a facaded filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Added coord system convert.
//
// ****************************************************************************

avtTransformFilter::~avtTransformFilter()
{
    if (stf != NULL)
        delete stf;
    if (csc != NULL)
        delete csc;
}


// ****************************************************************************
//  Method:  avtTransformFilter::Create
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
// ****************************************************************************

avtFilter *
avtTransformFilter::Create()
{
    return new avtTransformFilter();
}


// ****************************************************************************
//  Method:      avtTransformFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Delete invM.
//
//    Kathleen Bonnell, Wed May 21 11:38:23 PDT 2003   
//    Check for bad axis of rotation. 
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Blew away any interpretation of atts and added code to make similarity
//    transform atts and pass it to that filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Also add support for coordinate transformations.
//
// ****************************************************************************

void
avtTransformFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const TransformAttributes*)a;

    if (atts.GetTransformType() == TransformAttributes::Similarity)
    {
        SimilarityTransformAttributes st_atts;
        st_atts.SetDoRotate(atts.GetDoRotate());
        st_atts.SetRotateOrigin(atts.GetRotateOrigin());
        st_atts.SetRotateAxis(atts.GetRotateAxis());
        st_atts.SetRotateAmount(atts.GetRotateAmount());
        switch (atts.GetRotateType())
        {
          case TransformAttributes::Deg:
            st_atts.SetRotateType(SimilarityTransformAttributes::Deg);
            break;
          case TransformAttributes::Rad:
            st_atts.SetRotateType(SimilarityTransformAttributes::Rad);
            break;
        }
        st_atts.SetDoScale(atts.GetDoScale());
        st_atts.SetScaleOrigin(atts.GetScaleOrigin());
        st_atts.SetScaleX(atts.GetScaleX());
        st_atts.SetScaleY(atts.GetScaleY());
        st_atts.SetScaleZ(atts.GetScaleZ());
        st_atts.SetDoTranslate(atts.GetDoTranslate());
        st_atts.SetTranslateX(atts.GetTranslateX());
        st_atts.SetTranslateY(atts.GetTranslateY());
        st_atts.SetTranslateZ(atts.GetTranslateZ());
    
        stf->SetAtts(&st_atts);
    }
    else
    {
        switch (atts.GetInputCoordSys())
        {
           case TransformAttributes::Cartesian:
             csc->SetInputCoordSys(CARTESIAN);
             break;
           case TransformAttributes::Cylindrical:
             csc->SetInputCoordSys(CYLINDRICAL);
             break;
           case TransformAttributes::Spherical:
             csc->SetInputCoordSys(SPHERICAL);
             break;
        }
        switch (atts.GetOutputCoordSys())
        {
           case TransformAttributes::Cartesian:
             csc->SetOutputCoordSys(CARTESIAN);
             break;
           case TransformAttributes::Cylindrical:
             csc->SetOutputCoordSys(CYLINDRICAL);
             break;
           case TransformAttributes::Spherical:
             csc->SetOutputCoordSys(SPHERICAL);
             break;
        }
    }
}


// ****************************************************************************
//  Method: avtTransformFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtTransformFilter with the given
//      parameters would result in an equivalent avtTransformFilter.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
// ****************************************************************************

bool
avtTransformFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(TransformAttributes*)a);
}


// ****************************************************************************
//  Method: avtTransformFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter we are facading (the similarity transform filter).
//
//  Programmer: Hank Childs
//  Creation:   July 1, 2003
//
//  Modifications:
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Add support for coordinate systems.
//
// ****************************************************************************

avtFilter *
avtTransformFilter::GetFacadedFilter(void)
{
    if (atts.GetTransformType() == TransformAttributes::Similarity)
        return stf;
    else
        return csc;
}


