// ************************************************************************* //
//  File: TransformViewerPluginInfo.C
// ************************************************************************* //

#include <TransformPluginInfo.h>
#include <TransformAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Transform_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Transform operator.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    TransformViewerPluginInfo::InitializeGlobalObjects();
    return new TransformViewerPluginInfo;
}

//
// Storage for static data elements.
//
TransformAttributes *TransformViewerPluginInfo::clientAtts = NULL;
TransformAttributes *TransformViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TransformViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************
void
TransformViewerPluginInfo::InitializeGlobalObjects()
{
    TransformViewerPluginInfo::clientAtts  = new TransformAttributes;
    TransformViewerPluginInfo::defaultAtts = new TransformAttributes;
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

AttributeSubject *
TransformViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

AttributeSubject *
TransformViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

void
TransformViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TransformAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

void
TransformViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TransformAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

void
TransformViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(TransformAttributes*)atts = *defaultAtts;
    else
        *(TransformAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TransformViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Feb 4 15:40:10 PST 2005
//
// ****************************************************************************

#include <Transform.xpm>
const char **
TransformViewerPluginInfo::XPMIconData() const
{
    return Transform_xpm;
}
