// ************************************************************************* //
//                        TransformScriptingPluginInfo.C
// ************************************************************************* //
#include <TransformPluginInfo.h>
#include <PyTransformAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Transform_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Transform plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new TransformScriptingPluginInfo;
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TransformScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyTransformAttributes_StartUp((TransformAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
TransformScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTransformAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Transform plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
TransformScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTransformAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TransformScriptingPluginInfo::SetLogging(bool val)
{
    PyTransformAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: TransformScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:11 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
TransformScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTransformAttributes_SetDefaults((const TransformAttributes *)atts);
}
