// ************************************************************************* //
//  File: TransformGUIPluginInfo.C
// ************************************************************************* //

#include <TransformPluginInfo.h>
#include <TransformAttributes.h>
#include <QvisTransformWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Transform_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Transform operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:54:37 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new TransformGUIPluginInfo;
}

// ****************************************************************************
//  Method: TransformGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:54:37 PST 2003
//
// ****************************************************************************

const char *
TransformGUIPluginInfo::GetMenuName() const
{
    return "Transform";
}


// ****************************************************************************
//  Method: TransformGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:54:37 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
TransformGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisTransformWindow(type, (TransformAttributes *)attr,
        "Transform operator attributes", "Transform operator", notepad);
}

// ****************************************************************************
//  Method: TransformGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:54:37 PST 2003
//
// ****************************************************************************

#include <Transform.xpm>
const char **
TransformGUIPluginInfo::XPMIconData() const
{
    return Transform_xpm;
}
