#ifndef TRANSFORMATTRIBUTES_H
#define TRANSFORMATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: TransformAttributes
//
// Purpose:
//    This class contains attributes for the transform operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Feb 4 15:26:55 PST 2005
//
// Modifications:
//   
// ****************************************************************************

class TransformAttributes : public AttributeSubject
{
public:
    enum AngleType
    {
        Deg,
        Rad
    };
    enum TransformType
    {
        Similarity,
        Coordinate
    };
    enum CoordinateSystem
    {
        Cartesian,
        Cylindrical,
        Spherical
    };

    TransformAttributes();
    TransformAttributes(const TransformAttributes &obj);
    virtual ~TransformAttributes();

    virtual TransformAttributes& operator = (const TransformAttributes &obj);
    virtual bool operator == (const TransformAttributes &obj) const;
    virtual bool operator != (const TransformAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectRotateOrigin();
    void SelectRotateAxis();
    void SelectScaleOrigin();

    // Property setting methods
    void SetDoRotate(bool doRotate_);
    void SetRotateOrigin(const float *rotateOrigin_);
    void SetRotateAxis(const float *rotateAxis_);
    void SetRotateAmount(float rotateAmount_);
    void SetRotateType(AngleType rotateType_);
    void SetDoScale(bool doScale_);
    void SetScaleOrigin(const float *scaleOrigin_);
    void SetScaleX(float scaleX_);
    void SetScaleY(float scaleY_);
    void SetScaleZ(float scaleZ_);
    void SetDoTranslate(bool doTranslate_);
    void SetTranslateX(float translateX_);
    void SetTranslateY(float translateY_);
    void SetTranslateZ(float translateZ_);
    void SetTransformType(TransformType transformType_);
    void SetInputCoordSys(CoordinateSystem inputCoordSys_);
    void SetOutputCoordSys(CoordinateSystem outputCoordSys_);

    // Property getting methods
    bool        GetDoRotate() const;
    const float *GetRotateOrigin() const;
          float *GetRotateOrigin();
    const float *GetRotateAxis() const;
          float *GetRotateAxis();
    float       GetRotateAmount() const;
    AngleType   GetRotateType() const;
    bool        GetDoScale() const;
    const float *GetScaleOrigin() const;
          float *GetScaleOrigin();
    float       GetScaleX() const;
    float       GetScaleY() const;
    float       GetScaleZ() const;
    bool        GetDoTranslate() const;
    float       GetTranslateX() const;
    float       GetTranslateY() const;
    float       GetTranslateZ() const;
    TransformType GetTransformType() const;
    CoordinateSystem GetInputCoordSys() const;
    CoordinateSystem GetOutputCoordSys() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string AngleType_ToString(AngleType);
    static bool AngleType_FromString(const std::string &, AngleType &);
protected:
    static std::string AngleType_ToString(int);
public:
    static std::string TransformType_ToString(TransformType);
    static bool TransformType_FromString(const std::string &, TransformType &);
protected:
    static std::string TransformType_ToString(int);
public:
    static std::string CoordinateSystem_ToString(CoordinateSystem);
    static bool CoordinateSystem_FromString(const std::string &, CoordinateSystem &);
protected:
    static std::string CoordinateSystem_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    bool  doRotate;
    float rotateOrigin[3];
    float rotateAxis[3];
    float rotateAmount;
    int   rotateType;
    bool  doScale;
    float scaleOrigin[3];
    float scaleX;
    float scaleY;
    float scaleZ;
    bool  doTranslate;
    float translateX;
    float translateY;
    float translateZ;
    int   transformType;
    int   inputCoordSys;
    int   outputCoordSys;
};

#endif
