#include <PyTransformAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTransformAttributes
//
// Purpose: 
//   This class contains attributes for the transform operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Feb 4 15:40:14 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a TransformAttributes.
//
struct TransformAttributesObject
{
    PyObject_HEAD
    TransformAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewTransformAttributes();

static PyObject *
TransformAttributes_Notify(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_SetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doRotate in the object.
    obj->data->SetDoRotate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoRotate()?1L:0L);
    return retval;
}

static PyObject *
TransformAttributes_SetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetRotateOrigin();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateOrigin in the object as modified.
    obj->data->SelectRotateOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateOrigin.
    PyObject *retval = PyTuple_New(3);
    const float *rotateOrigin = obj->data->GetRotateOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(rotateOrigin[i])));
    return retval;
}

static PyObject *
TransformAttributes_SetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetRotateAxis();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateAxis in the object as modified.
    obj->data->SelectRotateAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateAxis.
    PyObject *retval = PyTuple_New(3);
    const float *rotateAxis = obj->data->GetRotateAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(rotateAxis[i])));
    return retval;
}

static PyObject *
TransformAttributes_SetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the rotateAmount in the object.
    obj->data->SetRotateAmount(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRotateAmount()));
    return retval;
}

static PyObject *
TransformAttributes_SetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rotateType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetRotateType(TransformAttributes::AngleType(ival));
    else
    {
        fprintf(stderr, "An invalid rotateType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Deg, Rad.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRotateType()));
    return retval;
}

static PyObject *
TransformAttributes_SetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doScale in the object.
    obj->data->SetDoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoScale()?1L:0L);
    return retval;
}

static PyObject *
TransformAttributes_SetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetScaleOrigin();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the scaleOrigin in the object as modified.
    obj->data->SelectScaleOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the scaleOrigin.
    PyObject *retval = PyTuple_New(3);
    const float *scaleOrigin = obj->data->GetScaleOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(scaleOrigin[i])));
    return retval;
}

static PyObject *
TransformAttributes_SetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleX in the object.
    obj->data->SetScaleX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleX()));
    return retval;
}

static PyObject *
TransformAttributes_SetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleY in the object.
    obj->data->SetScaleY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleY()));
    return retval;
}

static PyObject *
TransformAttributes_SetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleZ in the object.
    obj->data->SetScaleZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleZ()));
    return retval;
}

static PyObject *
TransformAttributes_SetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTranslate in the object.
    obj->data->SetDoTranslate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTranslate()?1L:0L);
    return retval;
}

static PyObject *
TransformAttributes_SetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateX in the object.
    obj->data->SetTranslateX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateX()));
    return retval;
}

static PyObject *
TransformAttributes_SetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateY in the object.
    obj->data->SetTranslateY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateY()));
    return retval;
}

static PyObject *
TransformAttributes_SetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateZ in the object.
    obj->data->SetTranslateZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateZ()));
    return retval;
}

static PyObject *
TransformAttributes_SetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the transformType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTransformType(TransformAttributes::TransformType(ival));
    else
    {
        fprintf(stderr, "An invalid transformType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Similarity, Coordinate.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTransformType()));
    return retval;
}

static PyObject *
TransformAttributes_SetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the inputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetInputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid inputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetInputCoordSys()));
    return retval;
}

static PyObject *
TransformAttributes_SetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOutputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid outputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TransformAttributes_GetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputCoordSys()));
    return retval;
}



static struct PyMethodDef TransformAttributes_methods[] = {
    {"Notify", TransformAttributes_Notify, METH_VARARGS},
    {"SetDoRotate", TransformAttributes_SetDoRotate, METH_VARARGS},
    {"GetDoRotate", TransformAttributes_GetDoRotate, METH_VARARGS},
    {"SetRotateOrigin", TransformAttributes_SetRotateOrigin, METH_VARARGS},
    {"GetRotateOrigin", TransformAttributes_GetRotateOrigin, METH_VARARGS},
    {"SetRotateAxis", TransformAttributes_SetRotateAxis, METH_VARARGS},
    {"GetRotateAxis", TransformAttributes_GetRotateAxis, METH_VARARGS},
    {"SetRotateAmount", TransformAttributes_SetRotateAmount, METH_VARARGS},
    {"GetRotateAmount", TransformAttributes_GetRotateAmount, METH_VARARGS},
    {"SetRotateType", TransformAttributes_SetRotateType, METH_VARARGS},
    {"GetRotateType", TransformAttributes_GetRotateType, METH_VARARGS},
    {"SetDoScale", TransformAttributes_SetDoScale, METH_VARARGS},
    {"GetDoScale", TransformAttributes_GetDoScale, METH_VARARGS},
    {"SetScaleOrigin", TransformAttributes_SetScaleOrigin, METH_VARARGS},
    {"GetScaleOrigin", TransformAttributes_GetScaleOrigin, METH_VARARGS},
    {"SetScaleX", TransformAttributes_SetScaleX, METH_VARARGS},
    {"GetScaleX", TransformAttributes_GetScaleX, METH_VARARGS},
    {"SetScaleY", TransformAttributes_SetScaleY, METH_VARARGS},
    {"GetScaleY", TransformAttributes_GetScaleY, METH_VARARGS},
    {"SetScaleZ", TransformAttributes_SetScaleZ, METH_VARARGS},
    {"GetScaleZ", TransformAttributes_GetScaleZ, METH_VARARGS},
    {"SetDoTranslate", TransformAttributes_SetDoTranslate, METH_VARARGS},
    {"GetDoTranslate", TransformAttributes_GetDoTranslate, METH_VARARGS},
    {"SetTranslateX", TransformAttributes_SetTranslateX, METH_VARARGS},
    {"GetTranslateX", TransformAttributes_GetTranslateX, METH_VARARGS},
    {"SetTranslateY", TransformAttributes_SetTranslateY, METH_VARARGS},
    {"GetTranslateY", TransformAttributes_GetTranslateY, METH_VARARGS},
    {"SetTranslateZ", TransformAttributes_SetTranslateZ, METH_VARARGS},
    {"GetTranslateZ", TransformAttributes_GetTranslateZ, METH_VARARGS},
    {"SetTransformType", TransformAttributes_SetTransformType, METH_VARARGS},
    {"GetTransformType", TransformAttributes_GetTransformType, METH_VARARGS},
    {"SetInputCoordSys", TransformAttributes_SetInputCoordSys, METH_VARARGS},
    {"GetInputCoordSys", TransformAttributes_GetInputCoordSys, METH_VARARGS},
    {"SetOutputCoordSys", TransformAttributes_SetOutputCoordSys, METH_VARARGS},
    {"GetOutputCoordSys", TransformAttributes_GetOutputCoordSys, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TransformAttributes_dealloc(PyObject *v)
{
   TransformAttributesObject *obj = (TransformAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
TransformAttributes_compare(PyObject *v, PyObject *w)
{
    TransformAttributes *a = ((TransformAttributesObject *)v)->data;
    TransformAttributes *b = ((TransformAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
TransformAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "doRotate") == 0)
        return TransformAttributes_GetDoRotate(self, NULL);
    if(strcmp(name, "rotateOrigin") == 0)
        return TransformAttributes_GetRotateOrigin(self, NULL);
    if(strcmp(name, "rotateAxis") == 0)
        return TransformAttributes_GetRotateAxis(self, NULL);
    if(strcmp(name, "rotateAmount") == 0)
        return TransformAttributes_GetRotateAmount(self, NULL);
    if(strcmp(name, "rotateType") == 0)
        return TransformAttributes_GetRotateType(self, NULL);
    if(strcmp(name, "Deg") == 0)
        return PyInt_FromLong(long(TransformAttributes::Deg));
    else if(strcmp(name, "Rad") == 0)
        return PyInt_FromLong(long(TransformAttributes::Rad));

    if(strcmp(name, "doScale") == 0)
        return TransformAttributes_GetDoScale(self, NULL);
    if(strcmp(name, "scaleOrigin") == 0)
        return TransformAttributes_GetScaleOrigin(self, NULL);
    if(strcmp(name, "scaleX") == 0)
        return TransformAttributes_GetScaleX(self, NULL);
    if(strcmp(name, "scaleY") == 0)
        return TransformAttributes_GetScaleY(self, NULL);
    if(strcmp(name, "scaleZ") == 0)
        return TransformAttributes_GetScaleZ(self, NULL);
    if(strcmp(name, "doTranslate") == 0)
        return TransformAttributes_GetDoTranslate(self, NULL);
    if(strcmp(name, "translateX") == 0)
        return TransformAttributes_GetTranslateX(self, NULL);
    if(strcmp(name, "translateY") == 0)
        return TransformAttributes_GetTranslateY(self, NULL);
    if(strcmp(name, "translateZ") == 0)
        return TransformAttributes_GetTranslateZ(self, NULL);
    if(strcmp(name, "transformType") == 0)
        return TransformAttributes_GetTransformType(self, NULL);
    if(strcmp(name, "Similarity") == 0)
        return PyInt_FromLong(long(TransformAttributes::Similarity));
    else if(strcmp(name, "Coordinate") == 0)
        return PyInt_FromLong(long(TransformAttributes::Coordinate));

    if(strcmp(name, "inputCoordSys") == 0)
        return TransformAttributes_GetInputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    else if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    else if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));

    if(strcmp(name, "outputCoordSys") == 0)
        return TransformAttributes_GetOutputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    else if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    else if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));


    return Py_FindMethod(TransformAttributes_methods, self, name);
}

static int
TransformAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "doRotate") == 0)
        retval = (TransformAttributes_SetDoRotate(self, tuple) != NULL);
    else if(strcmp(name, "rotateOrigin") == 0)
        retval = (TransformAttributes_SetRotateOrigin(self, tuple) != NULL);
    else if(strcmp(name, "rotateAxis") == 0)
        retval = (TransformAttributes_SetRotateAxis(self, tuple) != NULL);
    else if(strcmp(name, "rotateAmount") == 0)
        retval = (TransformAttributes_SetRotateAmount(self, tuple) != NULL);
    else if(strcmp(name, "rotateType") == 0)
        retval = (TransformAttributes_SetRotateType(self, tuple) != NULL);
    else if(strcmp(name, "doScale") == 0)
        retval = (TransformAttributes_SetDoScale(self, tuple) != NULL);
    else if(strcmp(name, "scaleOrigin") == 0)
        retval = (TransformAttributes_SetScaleOrigin(self, tuple) != NULL);
    else if(strcmp(name, "scaleX") == 0)
        retval = (TransformAttributes_SetScaleX(self, tuple) != NULL);
    else if(strcmp(name, "scaleY") == 0)
        retval = (TransformAttributes_SetScaleY(self, tuple) != NULL);
    else if(strcmp(name, "scaleZ") == 0)
        retval = (TransformAttributes_SetScaleZ(self, tuple) != NULL);
    else if(strcmp(name, "doTranslate") == 0)
        retval = (TransformAttributes_SetDoTranslate(self, tuple) != NULL);
    else if(strcmp(name, "translateX") == 0)
        retval = (TransformAttributes_SetTranslateX(self, tuple) != NULL);
    else if(strcmp(name, "translateY") == 0)
        retval = (TransformAttributes_SetTranslateY(self, tuple) != NULL);
    else if(strcmp(name, "translateZ") == 0)
        retval = (TransformAttributes_SetTranslateZ(self, tuple) != NULL);
    else if(strcmp(name, "transformType") == 0)
        retval = (TransformAttributes_SetTransformType(self, tuple) != NULL);
    else if(strcmp(name, "inputCoordSys") == 0)
        retval = (TransformAttributes_SetInputCoordSys(self, tuple) != NULL);
    else if(strcmp(name, "outputCoordSys") == 0)
        retval = (TransformAttributes_SetOutputCoordSys(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
TransformAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;

    if(obj->data->GetDoRotate())
        fprintf(fp, "doRotate = 1\n");
    else
        fprintf(fp, "doRotate = 0\n");
    {   const float *rotateOrigin = obj->data->GetRotateOrigin();
        fprintf(fp, "rotateOrigin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", rotateOrigin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const float *rotateAxis = obj->data->GetRotateAxis();
        fprintf(fp, "rotateAxis = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", rotateAxis[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "rotateAmount = %g\n", obj->data->GetRotateAmount());
    const char *rotateType_names = "Deg, Rad";
    if(obj->data->GetRotateType() == TransformAttributes::Deg)
        fprintf(fp, "rotateType = Deg  # %s\n", rotateType_names);
    else
        fprintf(fp, "rotateType = Rad  # %s\n", rotateType_names);

    if(obj->data->GetDoScale())
        fprintf(fp, "doScale = 1\n");
    else
        fprintf(fp, "doScale = 0\n");
    {   const float *scaleOrigin = obj->data->GetScaleOrigin();
        fprintf(fp, "scaleOrigin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", scaleOrigin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "scaleX = %g\n", obj->data->GetScaleX());
    fprintf(fp, "scaleY = %g\n", obj->data->GetScaleY());
    fprintf(fp, "scaleZ = %g\n", obj->data->GetScaleZ());
    if(obj->data->GetDoTranslate())
        fprintf(fp, "doTranslate = 1\n");
    else
        fprintf(fp, "doTranslate = 0\n");
    fprintf(fp, "translateX = %g\n", obj->data->GetTranslateX());
    fprintf(fp, "translateY = %g\n", obj->data->GetTranslateY());
    fprintf(fp, "translateZ = %g\n", obj->data->GetTranslateZ());
    const char *transformType_names = "Similarity, Coordinate";
    if(obj->data->GetTransformType() == TransformAttributes::Similarity)
        fprintf(fp, "transformType = Similarity  # %s\n", transformType_names);
    else
        fprintf(fp, "transformType = Coordinate  # %s\n", transformType_names);

    const char *inputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    if(obj->data->GetInputCoordSys() == TransformAttributes::Cartesian)
        fprintf(fp, "inputCoordSys = Cartesian  # %s\n", inputCoordSys_names);
    else if(obj->data->GetInputCoordSys() == TransformAttributes::Cylindrical)
        fprintf(fp, "inputCoordSys = Cylindrical  # %s\n", inputCoordSys_names);
    else
        fprintf(fp, "inputCoordSys = Spherical  # %s\n", inputCoordSys_names);

    const char *outputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    if(obj->data->GetOutputCoordSys() == TransformAttributes::Cartesian)
        fprintf(fp, "outputCoordSys = Cartesian  # %s\n", outputCoordSys_names);
    else if(obj->data->GetOutputCoordSys() == TransformAttributes::Cylindrical)
        fprintf(fp, "outputCoordSys = Cylindrical  # %s\n", outputCoordSys_names);
    else
        fprintf(fp, "outputCoordSys = Spherical  # %s\n", outputCoordSys_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyTransformAttributes_StringRepresentation(const TransformAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetDoRotate())
        SNPRINTF(tmpStr, 1000, "doRotate = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doRotate = 0\n");
    str += tmpStr;
    {   const float *rotateOrigin = atts->GetRotateOrigin();
        SNPRINTF(tmpStr, 1000, "rotateOrigin = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *rotateAxis = atts->GetRotateAxis();
        SNPRINTF(tmpStr, 1000, "rotateAxis = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "rotateAmount = %g\n", atts->GetRotateAmount());
    str += tmpStr;
    const char *rotateType_names = "Deg, Rad";
    if(atts->GetRotateType() == TransformAttributes::Deg)
        {
             SNPRINTF(tmpStr, 1000, "rotateType = Deg  # %s\n", rotateType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "rotateType = Rad  # %s\n", rotateType_names);
             str += tmpStr;
        }

    if(atts->GetDoScale())
        SNPRINTF(tmpStr, 1000, "doScale = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doScale = 0\n");
    str += tmpStr;
    {   const float *scaleOrigin = atts->GetScaleOrigin();
        SNPRINTF(tmpStr, 1000, "scaleOrigin = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", scaleOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "scaleX = %g\n", atts->GetScaleX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "scaleY = %g\n", atts->GetScaleY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "scaleZ = %g\n", atts->GetScaleZ());
    str += tmpStr;
    if(atts->GetDoTranslate())
        SNPRINTF(tmpStr, 1000, "doTranslate = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doTranslate = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "translateX = %g\n", atts->GetTranslateX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "translateY = %g\n", atts->GetTranslateY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "translateZ = %g\n", atts->GetTranslateZ());
    str += tmpStr;
    const char *transformType_names = "Similarity, Coordinate";
    if(atts->GetTransformType() == TransformAttributes::Similarity)
        {
             SNPRINTF(tmpStr, 1000, "transformType = Similarity  # %s\n", transformType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "transformType = Coordinate  # %s\n", transformType_names);
             str += tmpStr;
        }

    const char *inputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    if(atts->GetInputCoordSys() == TransformAttributes::Cartesian)
        {
             SNPRINTF(tmpStr, 1000, "inputCoordSys = Cartesian  # %s\n", inputCoordSys_names);
             str += tmpStr;
        }
    else if(atts->GetInputCoordSys() == TransformAttributes::Cylindrical)
        {
             SNPRINTF(tmpStr, 1000, "inputCoordSys = Cylindrical  # %s\n", inputCoordSys_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "inputCoordSys = Spherical  # %s\n", inputCoordSys_names);
             str += tmpStr;
        }

    const char *outputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    if(atts->GetOutputCoordSys() == TransformAttributes::Cartesian)
        {
             SNPRINTF(tmpStr, 1000, "outputCoordSys = Cartesian  # %s\n", outputCoordSys_names);
             str += tmpStr;
        }
    else if(atts->GetOutputCoordSys() == TransformAttributes::Cylindrical)
        {
             SNPRINTF(tmpStr, 1000, "outputCoordSys = Cylindrical  # %s\n", outputCoordSys_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "outputCoordSys = Spherical  # %s\n", outputCoordSys_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
TransformAttributes_str(PyObject *v)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;
    return PyTransformAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *TransformAttributes_Purpose = "This class contains attributes for the transform operator.";

//
// The type description structure
//
static PyTypeObject TransformAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TransformAttributes",                    // tp_name
    sizeof(TransformAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TransformAttributes_dealloc,  // tp_dealloc
    (printfunc)TransformAttributes_print,     // tp_print
    (getattrfunc)TransformAttributes_getattr, // tp_getattr
    (setattrfunc)TransformAttributes_setattr, // tp_setattr
    (cmpfunc)TransformAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TransformAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TransformAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TransformAttributes *defaultAtts = 0;

static PyObject *
NewTransformAttributes()
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new TransformAttributes(*defaultAtts);
    else
        newObject->data = new TransformAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapTransformAttributes(const TransformAttributes *attr)
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TransformAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TransformAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewTransformAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TransformAttributesMethods[] = {
    {"TransformAttributes", TransformAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TransformAttributesObserver = 0;
static bool TransformAttributesEnableLogging = true;

static void
PyTransformAttributes_WriteLog(Subject *subj, void *data)
{
    TransformAttributes *atts = (TransformAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!TransformAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# TransformAttributes_WriteLog()\n");
}

void
PyTransformAttributes_StartUp(TransformAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyTransformAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TransformAttributesObserver == 0)
    {
        TransformAttributesObserver = new ObserverToCallback(subj,
            PyTransformAttributes_WriteLog, (void *)logFile);
    }

    TransformAttributesEnableLogging = true;
}

void
PyTransformAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TransformAttributesObserver;
    TransformAttributesObserver = 0;
}

PyMethodDef *
PyTransformAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TransformAttributesMethods;
}

bool
PyTransformAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TransformAttributesType);
}

TransformAttributes *
PyTransformAttributes_FromPyObject(PyObject *obj)
{
    TransformAttributesObject *obj2 = (TransformAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTransformAttributes_NewPyObject()
{
    return NewTransformAttributes();
}

PyObject *
PyTransformAttributes_WrapPyObject(const TransformAttributes *attr)
{
    return WrapTransformAttributes(attr);
}

void
PyTransformAttributes_SetLogging(bool val)
{
    TransformAttributesEnableLogging = val;
}

void
PyTransformAttributes_SetDefaults(const TransformAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TransformAttributes(*atts);
}

