// ************************************************************************* //
//  File: ThresholdViewerPluginInfo.C
// ************************************************************************* //

#include <ThresholdPluginInfo.h>
#include <ThresholdAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo Threshold_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Threshold operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ThresholdViewerPluginInfo::InitializeGlobalObjects();
    return new ThresholdViewerPluginInfo;
}

//
// Storage for static data elements.
//
ThresholdAttributes *ThresholdViewerPluginInfo::clientAtts = NULL;
ThresholdAttributes *ThresholdViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ThresholdViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************
void
ThresholdViewerPluginInfo::InitializeGlobalObjects()
{
    ThresholdViewerPluginInfo::clientAtts  = new ThresholdAttributes;
    ThresholdViewerPluginInfo::defaultAtts = new ThresholdAttributes;
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

void
ThresholdViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ThresholdAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

void
ThresholdViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ThresholdAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

void
ThresholdViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ThresholdAttributes*)atts = *defaultAtts;
    else
        *(ThresholdAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
// ****************************************************************************

#include <Threshold.xpm>
const char **
ThresholdViewerPluginInfo::XPMIconData() const
{
    return Threshold_xpm;
}
