// ************************************************************************* //
//                        ThresholdScriptingPluginInfo.C
// ************************************************************************* //
#include <ThresholdPluginInfo.h>
#include <PyThresholdAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Threshold_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Threshold plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ThresholdScriptingPluginInfo;
}

// ****************************************************************************
// Method: ThresholdScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyThresholdAttributes_StartUp((ThresholdAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ThresholdScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ThresholdScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyThresholdAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ThresholdScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Threshold plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyThresholdAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ThresholdScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdScriptingPluginInfo::SetLogging(bool val)
{
    PyThresholdAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ThresholdScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyThresholdAttributes_SetDefaults((const ThresholdAttributes *)atts);
}
