// ************************************************************************* //
//  File: ThresholdPluginInfo.h
// ************************************************************************* //

#ifndef THRESHOLD_PLUGIN_INFO_H
#define THRESHOLD_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ThresholdAttributes;

// ****************************************************************************
//  Class: ThresholdPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Threshold operator
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:06:03 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class ThresholdGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class ThresholdCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ThresholdGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ThresholdGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ThresholdViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static ThresholdAttributes *defaultAtts;
    static ThresholdAttributes *clientAtts;
};

class ThresholdEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ThresholdScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ThresholdCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
