// ************************************************************************* //
//  File: ThresholdGUIPluginInfo.C
// ************************************************************************* //

#include <ThresholdPluginInfo.h>
#include <ThresholdAttributes.h>
#include <QvisThresholdWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Threshold_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Threshold operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:32:43 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ThresholdGUIPluginInfo;
}

// ****************************************************************************
//  Method: ThresholdGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:32:43 PST 2003
//
// ****************************************************************************

const char *
ThresholdGUIPluginInfo::GetMenuName() const
{
    return "Threshold";
}


// ****************************************************************************
//  Method: ThresholdGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:32:43 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
ThresholdGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisThresholdWindow(type, (ThresholdAttributes *)attr,
        "Threshold operator attributes", "Threshold operator", notepad);
}

// ****************************************************************************
//  Method: ThresholdGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 14:32:43 PST 2003
//
// ****************************************************************************

#include <Threshold.xpm>
const char **
ThresholdGUIPluginInfo::XPMIconData() const
{
    return Threshold_xpm;
}
