#ifndef THRESHOLDATTRIBUTES_H
#define THRESHOLDATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ThresholdAttributes
//
// Purpose:
//    This class contains attributes for the threshold operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class ThresholdAttributes : public AttributeSubject
{
public:
    enum Amount
    {
        Some,
        All
    };

    ThresholdAttributes();
    ThresholdAttributes(const ThresholdAttributes &obj);
    virtual ~ThresholdAttributes();

    virtual void operator = (const ThresholdAttributes &obj);
    virtual bool operator == (const ThresholdAttributes &obj) const;
    virtual bool operator != (const ThresholdAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();

    // Property setting methods
    void SetAmount(Amount amount_);
    void SetLbound(double lbound_);
    void SetUbound(double ubound_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    Amount            GetAmount() const;
    double            GetLbound() const;
    double            GetUbound() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Amount_ToString(Amount);
    static bool Amount_FromString(const std::string &, Amount &);
protected:
    static std::string Amount_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    int         amount;
    double      lbound;
    double      ubound;
    std::string variable;
};

#endif
