#include <ThresholdAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ThresholdAttributes::Amount
//

static const char *Amount_strings[] = {
"Some", "All"};

std::string
ThresholdAttributes::Amount_ToString(ThresholdAttributes::Amount t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Amount_strings[index];
}

std::string
ThresholdAttributes::Amount_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Amount_strings[index];
}

bool
ThresholdAttributes::Amount_FromString(const std::string &s, ThresholdAttributes::Amount &val)
{
    val = ThresholdAttributes::Some;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Amount_strings[i])
        {
            val = (Amount)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ThresholdAttributes::ThresholdAttributes
//
// Purpose: 
//   Constructor for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ThresholdAttributes::ThresholdAttributes() : AttributeSubject("idds")
{
    amount = Some;
    lbound = -1e+37;
    ubound = 1e+37;
    variable = "default";
}

// ****************************************************************************
// Method: ThresholdAttributes::ThresholdAttributes
//
// Purpose: 
//   Copy constructor for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ThresholdAttributes::ThresholdAttributes(const ThresholdAttributes &obj) : AttributeSubject("idds")
{
    amount = obj.amount;
    lbound = obj.lbound;
    ubound = obj.ubound;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: ThresholdAttributes::~ThresholdAttributes
//
// Purpose: 
//   Destructor for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ThresholdAttributes::~ThresholdAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ThresholdAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdAttributes::operator = (const ThresholdAttributes &obj)
{
    amount = obj.amount;
    lbound = obj.lbound;
    ubound = obj.ubound;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: ThresholdAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdAttributes::operator == (const ThresholdAttributes &obj) const
{
    // Create the return value
    return ((amount == obj.amount) &&
            (lbound == obj.lbound) &&
            (ubound == obj.ubound) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: ThresholdAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdAttributes::operator != (const ThresholdAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ThresholdAttributes::TypeName
//
// Purpose: 
//   Type name method for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ThresholdAttributes::TypeName() const
{
    return "ThresholdAttributes";
}

// ****************************************************************************
// Method: ThresholdAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ThresholdAttributes *tmp = (const ThresholdAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ThresholdAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ThresholdAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ThresholdAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ThresholdAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ThresholdAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ThresholdAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ThresholdAttributes(*this);
    else
        retval = new ThresholdAttributes;

    return retval;
}

// ****************************************************************************
// Method: ThresholdAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdAttributes::SelectAll()
{
    Select(0, (void *)&amount);
    Select(1, (void *)&lbound);
    Select(2, (void *)&ubound);
    Select(3, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ThresholdAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ThresholdAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ThresholdAttributes.
    DataNode *node = new DataNode("ThresholdAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("amount", Amount_ToString(amount)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lbound", lbound));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ubound", ubound));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ThresholdAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThresholdAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ThresholdAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("amount")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetAmount(Amount(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Amount value;
            if(Amount_FromString(node->AsString(), value))
                SetAmount(value);
        }
    }
    if((node = searchNode->GetNode("lbound")) != 0)
        SetLbound(node->AsDouble());
    if((node = searchNode->GetNode("ubound")) != 0)
        SetUbound(node->AsDouble());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ThresholdAttributes::SetAmount(ThresholdAttributes::Amount amount_)
{
    amount = amount_;
    Select(0, (void *)&amount);
}

void
ThresholdAttributes::SetLbound(double lbound_)
{
    lbound = lbound_;
    Select(1, (void *)&lbound);
}

void
ThresholdAttributes::SetUbound(double ubound_)
{
    ubound = ubound_;
    Select(2, (void *)&ubound);
}

void
ThresholdAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(3, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ThresholdAttributes::Amount
ThresholdAttributes::GetAmount() const
{
    return Amount(amount);
}

double
ThresholdAttributes::GetLbound() const
{
    return lbound;
}

double
ThresholdAttributes::GetUbound() const
{
    return ubound;
}

const std::string &
ThresholdAttributes::GetVariable() const
{
    return variable;
}

std::string &
ThresholdAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ThresholdAttributes::SelectVariable()
{
    Select(3, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ThresholdAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ThresholdAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Amount of cell in the range";
        case 1:  return "Lower bound";
        case 2:  return "Upper bound";
        case 3:  return "variable";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ThresholdAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ThresholdAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_double;
        case 2:  return FieldType_double;
        case 3:  return FieldType_variablename;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ThresholdAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ThresholdAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "double";
        case 2:  return "double";
        case 3:  return "variablename";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ThresholdAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThresholdAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ThresholdAttributes &obj = *((const ThresholdAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (amount == obj.amount);
        }
        break;
    case 1:
        {  // new scope
        retval = (lbound == obj.lbound);
        }
        break;
    case 2:
        {  // new scope
        retval = (ubound == obj.ubound);
        }
        break;
    case 3:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

