#include <PyThresholdAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyThresholdAttributes
//
// Purpose: 
//   This class contains attributes for the threshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Dec 16 10:28:20 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThresholdAttributes.
//
struct ThresholdAttributesObject
{
    PyObject_HEAD
    ThresholdAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewThresholdAttributes();

static PyObject *
ThresholdAttributes_Notify(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThresholdAttributes_SetAmount(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the amount in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAmount(ThresholdAttributes::Amount(ival));
    else
    {
        fprintf(stderr, "An invalid amount value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Some, All.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThresholdAttributes_GetAmount(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAmount()));
    return retval;
}

static PyObject *
ThresholdAttributes_SetLbound(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lbound in the object.
    obj->data->SetLbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThresholdAttributes_GetLbound(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLbound());
    return retval;
}

static PyObject *
ThresholdAttributes_SetUbound(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the ubound in the object.
    obj->data->SetUbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThresholdAttributes_GetUbound(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUbound());
    return retval;
}

static PyObject *
ThresholdAttributes_SetVariable(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThresholdAttributes_GetVariable(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef ThresholdAttributes_methods[] = {
    {"Notify", ThresholdAttributes_Notify, METH_VARARGS},
    {"SetAmount", ThresholdAttributes_SetAmount, METH_VARARGS},
    {"GetAmount", ThresholdAttributes_GetAmount, METH_VARARGS},
    {"SetLbound", ThresholdAttributes_SetLbound, METH_VARARGS},
    {"GetLbound", ThresholdAttributes_GetLbound, METH_VARARGS},
    {"SetUbound", ThresholdAttributes_SetUbound, METH_VARARGS},
    {"GetUbound", ThresholdAttributes_GetUbound, METH_VARARGS},
    {"SetVariable", ThresholdAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", ThresholdAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ThresholdAttributes_dealloc(PyObject *v)
{
   ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ThresholdAttributes_compare(PyObject *v, PyObject *w)
{
    ThresholdAttributes *a = ((ThresholdAttributesObject *)v)->data;
    ThresholdAttributes *b = ((ThresholdAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ThresholdAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "amount") == 0)
        return ThresholdAttributes_GetAmount(self, NULL);
    if(strcmp(name, "Some") == 0)
        return PyInt_FromLong(long(ThresholdAttributes::Some));
    else if(strcmp(name, "All") == 0)
        return PyInt_FromLong(long(ThresholdAttributes::All));

    if(strcmp(name, "lbound") == 0)
        return ThresholdAttributes_GetLbound(self, NULL);
    if(strcmp(name, "ubound") == 0)
        return ThresholdAttributes_GetUbound(self, NULL);
    if(strcmp(name, "variable") == 0)
        return ThresholdAttributes_GetVariable(self, NULL);

    return Py_FindMethod(ThresholdAttributes_methods, self, name);
}

static int
ThresholdAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "amount") == 0)
        retval = (ThresholdAttributes_SetAmount(self, tuple) != NULL);
    else if(strcmp(name, "lbound") == 0)
        retval = (ThresholdAttributes_SetLbound(self, tuple) != NULL);
    else if(strcmp(name, "ubound") == 0)
        retval = (ThresholdAttributes_SetUbound(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (ThresholdAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ThresholdAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;

    const char *amount_names = "Some, All";
    if(obj->data->GetAmount() == ThresholdAttributes::Some)
        fprintf(fp, "amount = Some  # %s\n", amount_names);
    else
        fprintf(fp, "amount = All  # %s\n", amount_names);

    fprintf(fp, "lbound = %g\n", obj->data->GetLbound());
    fprintf(fp, "ubound = %g\n", obj->data->GetUbound());
    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *ThresholdAttributes_Purpose = "This class contains attributes for the threshold operator.";

//
// The type description structure
//
static PyTypeObject ThresholdAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThresholdAttributes",                    // tp_name
    sizeof(ThresholdAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThresholdAttributes_dealloc,  // tp_dealloc
    (printfunc)ThresholdAttributes_print,     // tp_print
    (getattrfunc)ThresholdAttributes_getattr, // tp_getattr
    (setattrfunc)ThresholdAttributes_setattr, // tp_setattr
    (cmpfunc)ThresholdAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThresholdAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThresholdAttributes *defaultAtts = 0;

static PyObject *
NewThresholdAttributes()
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ThresholdAttributes(*defaultAtts);
    else
        newObject->data = new ThresholdAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapThresholdAttributes(const ThresholdAttributes *attr)
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThresholdAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThresholdAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewThresholdAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThresholdAttributesMethods[] = {
    {"ThresholdAttributes", ThresholdAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThresholdAttributesObserver = 0;
static bool ThresholdAttributesEnableLogging = true;

static void
PyThresholdAttributes_WriteLog(Subject *subj, void *data)
{
    ThresholdAttributes *atts = (ThresholdAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ThresholdAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ThresholdAttributes_WriteLog()\n");
}

void
PyThresholdAttributes_StartUp(ThresholdAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyThresholdAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThresholdAttributesObserver == 0)
    {
        ThresholdAttributesObserver = new ObserverToCallback(subj,
            PyThresholdAttributes_WriteLog, (void *)logFile);
    }

    ThresholdAttributesEnableLogging = true;
}

void
PyThresholdAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThresholdAttributesObserver;
    ThresholdAttributesObserver = 0;
}

PyMethodDef *
PyThresholdAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThresholdAttributesMethods;
}

bool
PyThresholdAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThresholdAttributesType);
}

ThresholdAttributes *
PyThresholdAttributes_FromPyObject(PyObject *obj)
{
    ThresholdAttributesObject *obj2 = (ThresholdAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThresholdAttributes_NewPyObject()
{
    return NewThresholdAttributes();
}

PyObject *
PyThresholdAttributes_WrapPyObject(const ThresholdAttributes *attr)
{
    return WrapThresholdAttributes(attr);
}

void
PyThresholdAttributes_SetLogging(bool val)
{
    ThresholdAttributesEnableLogging = val;
}

void
PyThresholdAttributes_SetDefaults(const ThresholdAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThresholdAttributes(*atts);
}

