// ************************************************************************* //
//  File: ThreeSliceViewerPluginInfo.C
// ************************************************************************* //

#include <ThreeSlicePluginInfo.h>
#include <ThreeSliceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo ThreeSlice_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the ThreeSlice operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    ThreeSliceViewerPluginInfo::InitializeGlobalObjects();
    return new ThreeSliceViewerPluginInfo;
}

//
// Storage for static data elements.
//
ThreeSliceAttributes *ThreeSliceViewerPluginInfo::clientAtts = NULL;
ThreeSliceAttributes *ThreeSliceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ThreeSliceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************
void
ThreeSliceViewerPluginInfo::InitializeGlobalObjects()
{
    ThreeSliceViewerPluginInfo::clientAtts  = new ThreeSliceAttributes;
    ThreeSliceViewerPluginInfo::defaultAtts = new ThreeSliceAttributes;
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

AttributeSubject *
ThreeSliceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

AttributeSubject *
ThreeSliceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

void
ThreeSliceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ThreeSliceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

void
ThreeSliceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ThreeSliceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

void
ThreeSliceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ThreeSliceAttributes*)atts = *defaultAtts;
    else
        *(ThreeSliceAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThreeSliceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:53 PST 2003
//
// ****************************************************************************

#include <ThreeSlice.xpm>
const char **
ThreeSliceViewerPluginInfo::XPMIconData() const
{
    return ThreeSlice_xpm;
}
