// ************************************************************************* //
//                        ThreeSliceScriptingPluginInfo.C
// ************************************************************************* //
#include <ThreeSlicePluginInfo.h>
#include <PyThreeSliceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo ThreeSlice_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the ThreeSlice plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new ThreeSliceScriptingPluginInfo;
}

// ****************************************************************************
// Method: ThreeSliceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThreeSliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyThreeSliceAttributes_StartUp((ThreeSliceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ThreeSliceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void *
ThreeSliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyThreeSliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ThreeSliceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is ThreeSlice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyThreeSliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ThreeSliceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThreeSliceScriptingPluginInfo::SetLogging(bool val)
{
    PyThreeSliceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ThreeSliceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
ThreeSliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyThreeSliceAttributes_SetDefaults((const ThreeSliceAttributes *)atts);
}
