// ************************************************************************* //
//  File: ThreeSliceGUIPluginInfo.C
// ************************************************************************* //

#include <ThreeSlicePluginInfo.h>
#include <ThreeSliceAttributes.h>
#include <QvisThreeSliceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo ThreeSlice_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the ThreeSlice operator.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new ThreeSliceGUIPluginInfo;
}

// ****************************************************************************
//  Method: ThreeSliceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// ****************************************************************************

const char *
ThreeSliceGUIPluginInfo::GetMenuName() const
{
    return "ThreeSlice";
}


// ****************************************************************************
//  Method: ThreeSliceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
ThreeSliceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisThreeSliceWindow(type, (ThreeSliceAttributes *)attr,
        "ThreeSlice operator attributes", "ThreeSlice operator", notepad);
}

// ****************************************************************************
//  Method: ThreeSliceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Wed Jul 2 15:36:50 PST 2003
//
// ****************************************************************************

#include <ThreeSlice.xpm>
const char **
ThreeSliceGUIPluginInfo::XPMIconData() const
{
    return ThreeSlice_xpm;
}
