#include <PyThreeSliceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyThreeSliceAttributes
//
// Purpose: 
//   This class contains attributes for the threeslice operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Jul 2 15:36:51 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThreeSliceAttributes.
//
struct ThreeSliceAttributesObject
{
    PyObject_HEAD
    ThreeSliceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewThreeSliceAttributes();

static PyObject *
ThreeSliceAttributes_Notify(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThreeSliceAttributes_SetX(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the x in the object.
    obj->data->SetX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThreeSliceAttributes_GetX(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetX()));
    return retval;
}

static PyObject *
ThreeSliceAttributes_SetY(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the y in the object.
    obj->data->SetY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThreeSliceAttributes_GetY(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetY()));
    return retval;
}

static PyObject *
ThreeSliceAttributes_SetZ(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the z in the object.
    obj->data->SetZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThreeSliceAttributes_GetZ(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetZ()));
    return retval;
}

static PyObject *
ThreeSliceAttributes_SetInteractive(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactive in the object.
    obj->data->SetInteractive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ThreeSliceAttributes_GetInteractive(PyObject *self, PyObject *args)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInteractive()?1L:0L);
    return retval;
}



static struct PyMethodDef ThreeSliceAttributes_methods[] = {
    {"Notify", ThreeSliceAttributes_Notify, METH_VARARGS},
    {"SetX", ThreeSliceAttributes_SetX, METH_VARARGS},
    {"GetX", ThreeSliceAttributes_GetX, METH_VARARGS},
    {"SetY", ThreeSliceAttributes_SetY, METH_VARARGS},
    {"GetY", ThreeSliceAttributes_GetY, METH_VARARGS},
    {"SetZ", ThreeSliceAttributes_SetZ, METH_VARARGS},
    {"GetZ", ThreeSliceAttributes_GetZ, METH_VARARGS},
    {"SetInteractive", ThreeSliceAttributes_SetInteractive, METH_VARARGS},
    {"GetInteractive", ThreeSliceAttributes_GetInteractive, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ThreeSliceAttributes_dealloc(PyObject *v)
{
   ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ThreeSliceAttributes_compare(PyObject *v, PyObject *w)
{
    ThreeSliceAttributes *a = ((ThreeSliceAttributesObject *)v)->data;
    ThreeSliceAttributes *b = ((ThreeSliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ThreeSliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "x") == 0)
        return ThreeSliceAttributes_GetX(self, NULL);
    if(strcmp(name, "y") == 0)
        return ThreeSliceAttributes_GetY(self, NULL);
    if(strcmp(name, "z") == 0)
        return ThreeSliceAttributes_GetZ(self, NULL);
    if(strcmp(name, "interactive") == 0)
        return ThreeSliceAttributes_GetInteractive(self, NULL);

    return Py_FindMethod(ThreeSliceAttributes_methods, self, name);
}

static int
ThreeSliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "x") == 0)
        retval = (ThreeSliceAttributes_SetX(self, tuple) != NULL);
    else if(strcmp(name, "y") == 0)
        retval = (ThreeSliceAttributes_SetY(self, tuple) != NULL);
    else if(strcmp(name, "z") == 0)
        retval = (ThreeSliceAttributes_SetZ(self, tuple) != NULL);
    else if(strcmp(name, "interactive") == 0)
        retval = (ThreeSliceAttributes_SetInteractive(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ThreeSliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThreeSliceAttributesObject *obj = (ThreeSliceAttributesObject *)v;

    fprintf(fp, "x = %g\n", obj->data->GetX());
    fprintf(fp, "y = %g\n", obj->data->GetY());
    fprintf(fp, "z = %g\n", obj->data->GetZ());
    if(obj->data->GetInteractive())
        fprintf(fp, "interactive = 1\n");
    else
        fprintf(fp, "interactive = 0\n");

    return 0;
}

//
// The doc string for the class.
//
static char *ThreeSliceAttributes_Purpose = "This class contains attributes for the threeslice operator.";

//
// The type description structure
//
static PyTypeObject ThreeSliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThreeSliceAttributes",                    // tp_name
    sizeof(ThreeSliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThreeSliceAttributes_dealloc,  // tp_dealloc
    (printfunc)ThreeSliceAttributes_print,     // tp_print
    (getattrfunc)ThreeSliceAttributes_getattr, // tp_getattr
    (setattrfunc)ThreeSliceAttributes_setattr, // tp_setattr
    (cmpfunc)ThreeSliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThreeSliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThreeSliceAttributes *defaultAtts = 0;

static PyObject *
NewThreeSliceAttributes()
{
    ThreeSliceAttributesObject *newObject;
    newObject = PyObject_NEW(ThreeSliceAttributesObject, &ThreeSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ThreeSliceAttributes(*defaultAtts);
    else
        newObject->data = new ThreeSliceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapThreeSliceAttributes(const ThreeSliceAttributes *attr)
{
    ThreeSliceAttributesObject *newObject;
    newObject = PyObject_NEW(ThreeSliceAttributesObject, &ThreeSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThreeSliceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThreeSliceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewThreeSliceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThreeSliceAttributesMethods[] = {
    {"ThreeSliceAttributes", ThreeSliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThreeSliceAttributesObserver = 0;
static bool ThreeSliceAttributesEnableLogging = true;

static void
PyThreeSliceAttributes_WriteLog(Subject *subj, void *data)
{
    ThreeSliceAttributes *atts = (ThreeSliceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ThreeSliceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ThreeSliceAttributes_WriteLog()\n");
}

void
PyThreeSliceAttributes_StartUp(ThreeSliceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyThreeSliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThreeSliceAttributesObserver == 0)
    {
        ThreeSliceAttributesObserver = new ObserverToCallback(subj,
            PyThreeSliceAttributes_WriteLog, (void *)logFile);
    }

    ThreeSliceAttributesEnableLogging = true;
}

void
PyThreeSliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThreeSliceAttributesObserver;
    ThreeSliceAttributesObserver = 0;
}

PyMethodDef *
PyThreeSliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThreeSliceAttributesMethods;
}

bool
PyThreeSliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThreeSliceAttributesType);
}

ThreeSliceAttributes *
PyThreeSliceAttributes_FromPyObject(PyObject *obj)
{
    ThreeSliceAttributesObject *obj2 = (ThreeSliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThreeSliceAttributes_NewPyObject()
{
    return NewThreeSliceAttributes();
}

PyObject *
PyThreeSliceAttributes_WrapPyObject(const ThreeSliceAttributes *attr)
{
    return WrapThreeSliceAttributes(attr);
}

void
PyThreeSliceAttributes_SetLogging(bool val)
{
    ThreeSliceAttributesEnableLogging = val;
}

void
PyThreeSliceAttributes_SetDefaults(const ThreeSliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThreeSliceAttributes(*atts);
}

