// ************************************************************************* //
//  File: SurfCompPrepViewerPluginInfo.C
// ************************************************************************* //

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo SurfCompPrep_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the SurfCompPrep operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    SurfCompPrepViewerPluginInfo::InitializeGlobalObjects();
    return new SurfCompPrepViewerPluginInfo;
}

//
// Storage for static data elements.
//
SurfCompPrepAttributes *SurfCompPrepViewerPluginInfo::clientAtts = NULL;
SurfCompPrepAttributes *SurfCompPrepViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SurfCompPrepViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************
void
SurfCompPrepViewerPluginInfo::InitializeGlobalObjects()
{
    SurfCompPrepViewerPluginInfo::clientAtts  = new SurfCompPrepAttributes;
    SurfCompPrepViewerPluginInfo::defaultAtts = new SurfCompPrepAttributes;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************

AttributeSubject *
SurfCompPrepViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************

AttributeSubject *
SurfCompPrepViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************

void
SurfCompPrepViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SurfCompPrepAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SurfCompPrepViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************

void
SurfCompPrepViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SurfCompPrepAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SurfCompPrepViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:40 PST 2003
//
// ****************************************************************************

void
SurfCompPrepViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SurfCompPrepAttributes*)atts = *defaultAtts;
    else
        *(SurfCompPrepAttributes*)atts = *clientAtts;
}
