// ************************************************************************* //
//                        SurfCompPrepScriptingPluginInfo.C
// ************************************************************************* //
#include <SurfCompPrepPluginInfo.h>
#include <PySurfCompPrepAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo SurfCompPrep_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the SurfCompPrep plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new SurfCompPrepScriptingPluginInfo;
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySurfCompPrepAttributes_StartUp((SurfCompPrepAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
SurfCompPrepScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySurfCompPrepAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is SurfCompPrep plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySurfCompPrepAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepScriptingPluginInfo::SetLogging(bool val)
{
    PySurfCompPrepAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SurfCompPrepScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySurfCompPrepAttributes_SetDefaults((const SurfCompPrepAttributes *)atts);
}
