// ************************************************************************* //
//  File: SurfCompPrepGUIPluginInfo.C
// ************************************************************************* //

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>
#include <QvisSurfCompPrepWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo SurfCompPrep_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the SurfCompPrep operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new SurfCompPrepGUIPluginInfo;
}

// ****************************************************************************
//  Method: SurfCompPrepGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// ****************************************************************************

const char *
SurfCompPrepGUIPluginInfo::GetMenuName() const
{
    return "SurfCompPrep";
}


// ****************************************************************************
//  Method: SurfCompPrepGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Jul 1 11:03:04 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
SurfCompPrepGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSurfCompPrepWindow(type, (SurfCompPrepAttributes *)attr,
        "SurfCompPrep operator attributes", "SurfCompPrep operator", notepad);
}
