#include <SurfCompPrepAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfCompPrepAttributes::CoordinateSystem
//

static const char *CoordinateSystem_strings[] = {
"Cartesian", "Cylindrical", "Spherical"
};

std::string
SurfCompPrepAttributes::CoordinateSystem_ToString(SurfCompPrepAttributes::CoordinateSystem t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return CoordinateSystem_strings[index];
}

std::string
SurfCompPrepAttributes::CoordinateSystem_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return CoordinateSystem_strings[index];
}

bool
SurfCompPrepAttributes::CoordinateSystem_FromString(const std::string &s, SurfCompPrepAttributes::CoordinateSystem &val)
{
    val = SurfCompPrepAttributes::Cartesian;
    for(int i = 0; i < 3; ++i)
    {
        if(s == CoordinateSystem_strings[i])
        {
            val = (CoordinateSystem)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfCompPrepAttributes::SurfaceType
//

static const char *SurfaceType_strings[] = {
"Closest", "Farthest", "Average"
};

std::string
SurfCompPrepAttributes::SurfaceType_ToString(SurfCompPrepAttributes::SurfaceType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return SurfaceType_strings[index];
}

std::string
SurfCompPrepAttributes::SurfaceType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return SurfaceType_strings[index];
}

bool
SurfCompPrepAttributes::SurfaceType_FromString(const std::string &s, SurfCompPrepAttributes::SurfaceType &val)
{
    val = SurfCompPrepAttributes::Closest;
    for(int i = 0; i < 3; ++i)
    {
        if(s == SurfaceType_strings[i])
        {
            val = (SurfaceType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SurfCompPrepAttributes
//
// Purpose: 
//   Constructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::SurfCompPrepAttributes() : AttributeSubject("iiddiddiddiddiddiddi")
{
    surfaceType = Average;
    coordSystem = Cartesian;
    thetaStart = 0;
    thetaStop = 360;
    thetaSteps = 90;
    phiStart = 0;
    phiStop = 180;
    phiSteps = 45;
    startRadius = 0;
    endRadius = 1;
    radiusSteps = 100;
    xStart = 0;
    xStop = 1;
    xSteps = 100;
    yStart = 0;
    yStop = 1;
    ySteps = 100;
    zStart = 0;
    zStop = 1;
    zSteps = 100;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SurfCompPrepAttributes
//
// Purpose: 
//   Copy constructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::SurfCompPrepAttributes(const SurfCompPrepAttributes &obj) : AttributeSubject("iiddiddiddiddiddiddi")
{
    surfaceType = obj.surfaceType;
    coordSystem = obj.coordSystem;
    thetaStart = obj.thetaStart;
    thetaStop = obj.thetaStop;
    thetaSteps = obj.thetaSteps;
    phiStart = obj.phiStart;
    phiStop = obj.phiStop;
    phiSteps = obj.phiSteps;
    startRadius = obj.startRadius;
    endRadius = obj.endRadius;
    radiusSteps = obj.radiusSteps;
    xStart = obj.xStart;
    xStop = obj.xStop;
    xSteps = obj.xSteps;
    yStart = obj.yStart;
    yStop = obj.yStop;
    ySteps = obj.ySteps;
    zStart = obj.zStart;
    zStop = obj.zStop;
    zSteps = obj.zSteps;

    SelectAll();
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::~SurfCompPrepAttributes
//
// Purpose: 
//   Destructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::~SurfCompPrepAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepAttributes::operator = (const SurfCompPrepAttributes &obj)
{
    surfaceType = obj.surfaceType;
    coordSystem = obj.coordSystem;
    thetaStart = obj.thetaStart;
    thetaStop = obj.thetaStop;
    thetaSteps = obj.thetaSteps;
    phiStart = obj.phiStart;
    phiStop = obj.phiStop;
    phiSteps = obj.phiSteps;
    startRadius = obj.startRadius;
    endRadius = obj.endRadius;
    radiusSteps = obj.radiusSteps;
    xStart = obj.xStart;
    xStop = obj.xStop;
    xSteps = obj.xSteps;
    yStart = obj.yStart;
    yStop = obj.yStop;
    ySteps = obj.ySteps;
    zStart = obj.zStart;
    zStop = obj.zStop;
    zSteps = obj.zSteps;

    SelectAll();
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::operator == (const SurfCompPrepAttributes &obj) const
{
    // Create the return value
    return ((surfaceType == obj.surfaceType) &&
            (coordSystem == obj.coordSystem) &&
            (thetaStart == obj.thetaStart) &&
            (thetaStop == obj.thetaStop) &&
            (thetaSteps == obj.thetaSteps) &&
            (phiStart == obj.phiStart) &&
            (phiStop == obj.phiStop) &&
            (phiSteps == obj.phiSteps) &&
            (startRadius == obj.startRadius) &&
            (endRadius == obj.endRadius) &&
            (radiusSteps == obj.radiusSteps) &&
            (xStart == obj.xStart) &&
            (xStop == obj.xStop) &&
            (xSteps == obj.xSteps) &&
            (yStart == obj.yStart) &&
            (yStop == obj.yStop) &&
            (ySteps == obj.ySteps) &&
            (zStart == obj.zStart) &&
            (zStop == obj.zStop) &&
            (zSteps == obj.zSteps));
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::operator != (const SurfCompPrepAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::TypeName
//
// Purpose: 
//   Type name method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
SurfCompPrepAttributes::TypeName() const
{
    return "SurfCompPrepAttributes";
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfCompPrepAttributes *tmp = (const SurfCompPrepAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfCompPrepAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfCompPrepAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfCompPrepAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfCompPrepAttributes(*this);
    else
        retval = new SurfCompPrepAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepAttributes::SelectAll()
{
    Select(0, (void *)&surfaceType);
    Select(1, (void *)&coordSystem);
    Select(2, (void *)&thetaStart);
    Select(3, (void *)&thetaStop);
    Select(4, (void *)&thetaSteps);
    Select(5, (void *)&phiStart);
    Select(6, (void *)&phiStop);
    Select(7, (void *)&phiSteps);
    Select(8, (void *)&startRadius);
    Select(9, (void *)&endRadius);
    Select(10, (void *)&radiusSteps);
    Select(11, (void *)&xStart);
    Select(12, (void *)&xStop);
    Select(13, (void *)&xSteps);
    Select(14, (void *)&yStart);
    Select(15, (void *)&yStop);
    Select(16, (void *)&ySteps);
    Select(17, (void *)&zStart);
    Select(18, (void *)&zStop);
    Select(19, (void *)&zSteps);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfCompPrepAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SurfCompPrepAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SurfCompPrepAttributes.
    DataNode *node = new DataNode("SurfCompPrepAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("surfaceType", SurfaceType_ToString(surfaceType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("coordSystem", CoordinateSystem_ToString(coordSystem)));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaStart", thetaStart));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaStop", thetaStop));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaSteps", thetaSteps));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiStart", phiStart));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiStop", phiStop));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiSteps", phiSteps));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startRadius", startRadius));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endRadius", endRadius));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radiusSteps", radiusSteps));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xStart", xStart));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xStop", xStop));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xSteps", xSteps));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yStart", yStart));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yStop", yStop));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ySteps", ySteps));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zStart", zStart));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zStop", zStop));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zSteps", zSteps));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SurfCompPrepAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("surfaceType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetSurfaceType(SurfaceType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SurfaceType value;
            if(SurfaceType_FromString(node->AsString(), value))
                SetSurfaceType(value);
        }
    }
    if((node = searchNode->GetNode("coordSystem")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetCoordSystem(CoordinateSystem(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            CoordinateSystem value;
            if(CoordinateSystem_FromString(node->AsString(), value))
                SetCoordSystem(value);
        }
    }
    if((node = searchNode->GetNode("thetaStart")) != 0)
        SetThetaStart(node->AsDouble());
    if((node = searchNode->GetNode("thetaStop")) != 0)
        SetThetaStop(node->AsDouble());
    if((node = searchNode->GetNode("thetaSteps")) != 0)
        SetThetaSteps(node->AsInt());
    if((node = searchNode->GetNode("phiStart")) != 0)
        SetPhiStart(node->AsDouble());
    if((node = searchNode->GetNode("phiStop")) != 0)
        SetPhiStop(node->AsDouble());
    if((node = searchNode->GetNode("phiSteps")) != 0)
        SetPhiSteps(node->AsInt());
    if((node = searchNode->GetNode("startRadius")) != 0)
        SetStartRadius(node->AsDouble());
    if((node = searchNode->GetNode("endRadius")) != 0)
        SetEndRadius(node->AsDouble());
    if((node = searchNode->GetNode("radiusSteps")) != 0)
        SetRadiusSteps(node->AsInt());
    if((node = searchNode->GetNode("xStart")) != 0)
        SetXStart(node->AsDouble());
    if((node = searchNode->GetNode("xStop")) != 0)
        SetXStop(node->AsDouble());
    if((node = searchNode->GetNode("xSteps")) != 0)
        SetXSteps(node->AsInt());
    if((node = searchNode->GetNode("yStart")) != 0)
        SetYStart(node->AsDouble());
    if((node = searchNode->GetNode("yStop")) != 0)
        SetYStop(node->AsDouble());
    if((node = searchNode->GetNode("ySteps")) != 0)
        SetYSteps(node->AsInt());
    if((node = searchNode->GetNode("zStart")) != 0)
        SetZStart(node->AsDouble());
    if((node = searchNode->GetNode("zStop")) != 0)
        SetZStop(node->AsDouble());
    if((node = searchNode->GetNode("zSteps")) != 0)
        SetZSteps(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfCompPrepAttributes::SetSurfaceType(SurfCompPrepAttributes::SurfaceType surfaceType_)
{
    surfaceType = surfaceType_;
    Select(0, (void *)&surfaceType);
}

void
SurfCompPrepAttributes::SetCoordSystem(SurfCompPrepAttributes::CoordinateSystem coordSystem_)
{
    coordSystem = coordSystem_;
    Select(1, (void *)&coordSystem);
}

void
SurfCompPrepAttributes::SetThetaStart(double thetaStart_)
{
    thetaStart = thetaStart_;
    Select(2, (void *)&thetaStart);
}

void
SurfCompPrepAttributes::SetThetaStop(double thetaStop_)
{
    thetaStop = thetaStop_;
    Select(3, (void *)&thetaStop);
}

void
SurfCompPrepAttributes::SetThetaSteps(int thetaSteps_)
{
    thetaSteps = thetaSteps_;
    Select(4, (void *)&thetaSteps);
}

void
SurfCompPrepAttributes::SetPhiStart(double phiStart_)
{
    phiStart = phiStart_;
    Select(5, (void *)&phiStart);
}

void
SurfCompPrepAttributes::SetPhiStop(double phiStop_)
{
    phiStop = phiStop_;
    Select(6, (void *)&phiStop);
}

void
SurfCompPrepAttributes::SetPhiSteps(int phiSteps_)
{
    phiSteps = phiSteps_;
    Select(7, (void *)&phiSteps);
}

void
SurfCompPrepAttributes::SetStartRadius(double startRadius_)
{
    startRadius = startRadius_;
    Select(8, (void *)&startRadius);
}

void
SurfCompPrepAttributes::SetEndRadius(double endRadius_)
{
    endRadius = endRadius_;
    Select(9, (void *)&endRadius);
}

void
SurfCompPrepAttributes::SetRadiusSteps(int radiusSteps_)
{
    radiusSteps = radiusSteps_;
    Select(10, (void *)&radiusSteps);
}

void
SurfCompPrepAttributes::SetXStart(double xStart_)
{
    xStart = xStart_;
    Select(11, (void *)&xStart);
}

void
SurfCompPrepAttributes::SetXStop(double xStop_)
{
    xStop = xStop_;
    Select(12, (void *)&xStop);
}

void
SurfCompPrepAttributes::SetXSteps(int xSteps_)
{
    xSteps = xSteps_;
    Select(13, (void *)&xSteps);
}

void
SurfCompPrepAttributes::SetYStart(double yStart_)
{
    yStart = yStart_;
    Select(14, (void *)&yStart);
}

void
SurfCompPrepAttributes::SetYStop(double yStop_)
{
    yStop = yStop_;
    Select(15, (void *)&yStop);
}

void
SurfCompPrepAttributes::SetYSteps(int ySteps_)
{
    ySteps = ySteps_;
    Select(16, (void *)&ySteps);
}

void
SurfCompPrepAttributes::SetZStart(double zStart_)
{
    zStart = zStart_;
    Select(17, (void *)&zStart);
}

void
SurfCompPrepAttributes::SetZStop(double zStop_)
{
    zStop = zStop_;
    Select(18, (void *)&zStop);
}

void
SurfCompPrepAttributes::SetZSteps(int zSteps_)
{
    zSteps = zSteps_;
    Select(19, (void *)&zSteps);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SurfCompPrepAttributes::SurfaceType
SurfCompPrepAttributes::GetSurfaceType() const
{
    return SurfaceType(surfaceType);
}

SurfCompPrepAttributes::CoordinateSystem
SurfCompPrepAttributes::GetCoordSystem() const
{
    return CoordinateSystem(coordSystem);
}

double
SurfCompPrepAttributes::GetThetaStart() const
{
    return thetaStart;
}

double
SurfCompPrepAttributes::GetThetaStop() const
{
    return thetaStop;
}

int
SurfCompPrepAttributes::GetThetaSteps() const
{
    return thetaSteps;
}

double
SurfCompPrepAttributes::GetPhiStart() const
{
    return phiStart;
}

double
SurfCompPrepAttributes::GetPhiStop() const
{
    return phiStop;
}

int
SurfCompPrepAttributes::GetPhiSteps() const
{
    return phiSteps;
}

double
SurfCompPrepAttributes::GetStartRadius() const
{
    return startRadius;
}

double
SurfCompPrepAttributes::GetEndRadius() const
{
    return endRadius;
}

int
SurfCompPrepAttributes::GetRadiusSteps() const
{
    return radiusSteps;
}

double
SurfCompPrepAttributes::GetXStart() const
{
    return xStart;
}

double
SurfCompPrepAttributes::GetXStop() const
{
    return xStop;
}

int
SurfCompPrepAttributes::GetXSteps() const
{
    return xSteps;
}

double
SurfCompPrepAttributes::GetYStart() const
{
    return yStart;
}

double
SurfCompPrepAttributes::GetYStop() const
{
    return yStop;
}

int
SurfCompPrepAttributes::GetYSteps() const
{
    return ySteps;
}

double
SurfCompPrepAttributes::GetZStart() const
{
    return zStart;
}

double
SurfCompPrepAttributes::GetZStop() const
{
    return zStop;
}

int
SurfCompPrepAttributes::GetZSteps() const
{
    return zSteps;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfCompPrepAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Method for inferring surface";
        case 1:  return "Coordinate System";
        case 2:  return "Start for Theta (degrees)";
        case 3:  return "Stop for Theta (degrees)";
        case 4:  return "Number of samples in Theta";
        case 5:  return "Start for Phi (degrees)";
        case 6:  return "Stop for Phi (degrees)";
        case 7:  return "Number of samples in Phi";
        case 8:  return "First radius to sample";
        case 9:  return "Last radius to sample";
        case 10:  return "Number of samples in radius";
        case 11:  return "Starting point for X";
        case 12:  return "Ending point for X";
        case 13:  return "Number of steps in X";
        case 14:  return "Starting point for Y";
        case 15:  return "Ending point for Y";
        case 16:  return "Number of steps in Y";
        case 17:  return "Starting point for Z";
        case 18:  return "Ending point for Z";
        case 19:  return "Number of steps in Z";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SurfCompPrepAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_double;
        case 3:  return FieldType_double;
        case 4:  return FieldType_int;
        case 5:  return FieldType_double;
        case 6:  return FieldType_double;
        case 7:  return FieldType_int;
        case 8:  return FieldType_double;
        case 9:  return FieldType_double;
        case 10:  return FieldType_int;
        case 11:  return FieldType_double;
        case 12:  return FieldType_double;
        case 13:  return FieldType_int;
        case 14:  return FieldType_double;
        case 15:  return FieldType_double;
        case 16:  return FieldType_int;
        case 17:  return FieldType_double;
        case 18:  return FieldType_double;
        case 19:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfCompPrepAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "enum";
        case 2:  return "double";
        case 3:  return "double";
        case 4:  return "int";
        case 5:  return "double";
        case 6:  return "double";
        case 7:  return "int";
        case 8:  return "double";
        case 9:  return "double";
        case 10:  return "int";
        case 11:  return "double";
        case 12:  return "double";
        case 13:  return "int";
        case 14:  return "double";
        case 15:  return "double";
        case 16:  return "int";
        case 17:  return "double";
        case 18:  return "double";
        case 19:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:50:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfCompPrepAttributes &obj = *((const SurfCompPrepAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (surfaceType == obj.surfaceType);
        }
        break;
    case 1:
        {  // new scope
        retval = (coordSystem == obj.coordSystem);
        }
        break;
    case 2:
        {  // new scope
        retval = (thetaStart == obj.thetaStart);
        }
        break;
    case 3:
        {  // new scope
        retval = (thetaStop == obj.thetaStop);
        }
        break;
    case 4:
        {  // new scope
        retval = (thetaSteps == obj.thetaSteps);
        }
        break;
    case 5:
        {  // new scope
        retval = (phiStart == obj.phiStart);
        }
        break;
    case 6:
        {  // new scope
        retval = (phiStop == obj.phiStop);
        }
        break;
    case 7:
        {  // new scope
        retval = (phiSteps == obj.phiSteps);
        }
        break;
    case 8:
        {  // new scope
        retval = (startRadius == obj.startRadius);
        }
        break;
    case 9:
        {  // new scope
        retval = (endRadius == obj.endRadius);
        }
        break;
    case 10:
        {  // new scope
        retval = (radiusSteps == obj.radiusSteps);
        }
        break;
    case 11:
        {  // new scope
        retval = (xStart == obj.xStart);
        }
        break;
    case 12:
        {  // new scope
        retval = (xStop == obj.xStop);
        }
        break;
    case 13:
        {  // new scope
        retval = (xSteps == obj.xSteps);
        }
        break;
    case 14:
        {  // new scope
        retval = (yStart == obj.yStart);
        }
        break;
    case 15:
        {  // new scope
        retval = (yStop == obj.yStop);
        }
        break;
    case 16:
        {  // new scope
        retval = (ySteps == obj.ySteps);
        }
        break;
    case 17:
        {  // new scope
        retval = (zStart == obj.zStart);
        }
        break;
    case 18:
        {  // new scope
        retval = (zStop == obj.zStop);
        }
        break;
    case 19:
        {  // new scope
        retval = (zSteps == obj.zSteps);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

