#include <PySurfCompPrepAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySurfCompPrepAttributes
//
// Purpose: 
//   Attributes for the SurfCompPrep operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Jul 1 11:03:05 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a SurfCompPrepAttributes.
//
struct SurfCompPrepAttributesObject
{
    PyObject_HEAD
    SurfCompPrepAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSurfCompPrepAttributes();

static PyObject *
SurfCompPrepAttributes_Notify(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_SetSurfaceType(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the surfaceType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSurfaceType(SurfCompPrepAttributes::SurfaceType(ival));
    else
    {
        fprintf(stderr, "An invalid surfaceType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Closest, Farthest, Average.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetSurfaceType(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSurfaceType()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetCoordSystem(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coordSystem in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCoordSystem(SurfCompPrepAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid coordSystem value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetCoordSystem(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCoordSystem()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetThetaStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the thetaStart in the object.
    obj->data->SetThetaStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetThetaStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThetaStart());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetThetaStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the thetaStop in the object.
    obj->data->SetThetaStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetThetaStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThetaStop());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetThetaSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the thetaSteps in the object.
    obj->data->SetThetaSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetThetaSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetThetaSteps()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetPhiStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the phiStart in the object.
    obj->data->SetPhiStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetPhiStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPhiStart());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetPhiStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the phiStop in the object.
    obj->data->SetPhiStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetPhiStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPhiStop());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetPhiSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the phiSteps in the object.
    obj->data->SetPhiSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetPhiSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPhiSteps()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetStartRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startRadius in the object.
    obj->data->SetStartRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetStartRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartRadius());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetEndRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endRadius in the object.
    obj->data->SetEndRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetEndRadius(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndRadius());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetRadiusSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the radiusSteps in the object.
    obj->data->SetRadiusSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetRadiusSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRadiusSteps()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetXStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xStart in the object.
    obj->data->SetXStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetXStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXStart());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetXStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xStop in the object.
    obj->data->SetXStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetXStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXStop());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetXSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xSteps in the object.
    obj->data->SetXSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetXSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXSteps()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetYStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yStart in the object.
    obj->data->SetYStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetYStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYStart());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetYStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yStop in the object.
    obj->data->SetYStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetYStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYStop());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetYSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ySteps in the object.
    obj->data->SetYSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetYSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYSteps()));
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetZStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zStart in the object.
    obj->data->SetZStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetZStart(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZStart());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetZStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zStop in the object.
    obj->data->SetZStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetZStop(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZStop());
    return retval;
}

static PyObject *
SurfCompPrepAttributes_SetZSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zSteps in the object.
    obj->data->SetZSteps(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfCompPrepAttributes_GetZSteps(PyObject *self, PyObject *args)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZSteps()));
    return retval;
}



static struct PyMethodDef SurfCompPrepAttributes_methods[] = {
    {"Notify", SurfCompPrepAttributes_Notify, METH_VARARGS},
    {"SetSurfaceType", SurfCompPrepAttributes_SetSurfaceType, METH_VARARGS},
    {"GetSurfaceType", SurfCompPrepAttributes_GetSurfaceType, METH_VARARGS},
    {"SetCoordSystem", SurfCompPrepAttributes_SetCoordSystem, METH_VARARGS},
    {"GetCoordSystem", SurfCompPrepAttributes_GetCoordSystem, METH_VARARGS},
    {"SetThetaStart", SurfCompPrepAttributes_SetThetaStart, METH_VARARGS},
    {"GetThetaStart", SurfCompPrepAttributes_GetThetaStart, METH_VARARGS},
    {"SetThetaStop", SurfCompPrepAttributes_SetThetaStop, METH_VARARGS},
    {"GetThetaStop", SurfCompPrepAttributes_GetThetaStop, METH_VARARGS},
    {"SetThetaSteps", SurfCompPrepAttributes_SetThetaSteps, METH_VARARGS},
    {"GetThetaSteps", SurfCompPrepAttributes_GetThetaSteps, METH_VARARGS},
    {"SetPhiStart", SurfCompPrepAttributes_SetPhiStart, METH_VARARGS},
    {"GetPhiStart", SurfCompPrepAttributes_GetPhiStart, METH_VARARGS},
    {"SetPhiStop", SurfCompPrepAttributes_SetPhiStop, METH_VARARGS},
    {"GetPhiStop", SurfCompPrepAttributes_GetPhiStop, METH_VARARGS},
    {"SetPhiSteps", SurfCompPrepAttributes_SetPhiSteps, METH_VARARGS},
    {"GetPhiSteps", SurfCompPrepAttributes_GetPhiSteps, METH_VARARGS},
    {"SetStartRadius", SurfCompPrepAttributes_SetStartRadius, METH_VARARGS},
    {"GetStartRadius", SurfCompPrepAttributes_GetStartRadius, METH_VARARGS},
    {"SetEndRadius", SurfCompPrepAttributes_SetEndRadius, METH_VARARGS},
    {"GetEndRadius", SurfCompPrepAttributes_GetEndRadius, METH_VARARGS},
    {"SetRadiusSteps", SurfCompPrepAttributes_SetRadiusSteps, METH_VARARGS},
    {"GetRadiusSteps", SurfCompPrepAttributes_GetRadiusSteps, METH_VARARGS},
    {"SetXStart", SurfCompPrepAttributes_SetXStart, METH_VARARGS},
    {"GetXStart", SurfCompPrepAttributes_GetXStart, METH_VARARGS},
    {"SetXStop", SurfCompPrepAttributes_SetXStop, METH_VARARGS},
    {"GetXStop", SurfCompPrepAttributes_GetXStop, METH_VARARGS},
    {"SetXSteps", SurfCompPrepAttributes_SetXSteps, METH_VARARGS},
    {"GetXSteps", SurfCompPrepAttributes_GetXSteps, METH_VARARGS},
    {"SetYStart", SurfCompPrepAttributes_SetYStart, METH_VARARGS},
    {"GetYStart", SurfCompPrepAttributes_GetYStart, METH_VARARGS},
    {"SetYStop", SurfCompPrepAttributes_SetYStop, METH_VARARGS},
    {"GetYStop", SurfCompPrepAttributes_GetYStop, METH_VARARGS},
    {"SetYSteps", SurfCompPrepAttributes_SetYSteps, METH_VARARGS},
    {"GetYSteps", SurfCompPrepAttributes_GetYSteps, METH_VARARGS},
    {"SetZStart", SurfCompPrepAttributes_SetZStart, METH_VARARGS},
    {"GetZStart", SurfCompPrepAttributes_GetZStart, METH_VARARGS},
    {"SetZStop", SurfCompPrepAttributes_SetZStop, METH_VARARGS},
    {"GetZStop", SurfCompPrepAttributes_GetZStop, METH_VARARGS},
    {"SetZSteps", SurfCompPrepAttributes_SetZSteps, METH_VARARGS},
    {"GetZSteps", SurfCompPrepAttributes_GetZSteps, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SurfCompPrepAttributes_dealloc(PyObject *v)
{
   SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SurfCompPrepAttributes_compare(PyObject *v, PyObject *w)
{
    SurfCompPrepAttributes *a = ((SurfCompPrepAttributesObject *)v)->data;
    SurfCompPrepAttributes *b = ((SurfCompPrepAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SurfCompPrepAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "surfaceType") == 0)
        return SurfCompPrepAttributes_GetSurfaceType(self, NULL);
    if(strcmp(name, "Closest") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Closest));
    else if(strcmp(name, "Farthest") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Farthest));
    else if(strcmp(name, "Average") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Average));

    if(strcmp(name, "coordSystem") == 0)
        return SurfCompPrepAttributes_GetCoordSystem(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Cartesian));
    else if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Cylindrical));
    else if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(SurfCompPrepAttributes::Spherical));

    if(strcmp(name, "thetaStart") == 0)
        return SurfCompPrepAttributes_GetThetaStart(self, NULL);
    if(strcmp(name, "thetaStop") == 0)
        return SurfCompPrepAttributes_GetThetaStop(self, NULL);
    if(strcmp(name, "thetaSteps") == 0)
        return SurfCompPrepAttributes_GetThetaSteps(self, NULL);
    if(strcmp(name, "phiStart") == 0)
        return SurfCompPrepAttributes_GetPhiStart(self, NULL);
    if(strcmp(name, "phiStop") == 0)
        return SurfCompPrepAttributes_GetPhiStop(self, NULL);
    if(strcmp(name, "phiSteps") == 0)
        return SurfCompPrepAttributes_GetPhiSteps(self, NULL);
    if(strcmp(name, "startRadius") == 0)
        return SurfCompPrepAttributes_GetStartRadius(self, NULL);
    if(strcmp(name, "endRadius") == 0)
        return SurfCompPrepAttributes_GetEndRadius(self, NULL);
    if(strcmp(name, "radiusSteps") == 0)
        return SurfCompPrepAttributes_GetRadiusSteps(self, NULL);
    if(strcmp(name, "xStart") == 0)
        return SurfCompPrepAttributes_GetXStart(self, NULL);
    if(strcmp(name, "xStop") == 0)
        return SurfCompPrepAttributes_GetXStop(self, NULL);
    if(strcmp(name, "xSteps") == 0)
        return SurfCompPrepAttributes_GetXSteps(self, NULL);
    if(strcmp(name, "yStart") == 0)
        return SurfCompPrepAttributes_GetYStart(self, NULL);
    if(strcmp(name, "yStop") == 0)
        return SurfCompPrepAttributes_GetYStop(self, NULL);
    if(strcmp(name, "ySteps") == 0)
        return SurfCompPrepAttributes_GetYSteps(self, NULL);
    if(strcmp(name, "zStart") == 0)
        return SurfCompPrepAttributes_GetZStart(self, NULL);
    if(strcmp(name, "zStop") == 0)
        return SurfCompPrepAttributes_GetZStop(self, NULL);
    if(strcmp(name, "zSteps") == 0)
        return SurfCompPrepAttributes_GetZSteps(self, NULL);

    return Py_FindMethod(SurfCompPrepAttributes_methods, self, name);
}

static int
SurfCompPrepAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "surfaceType") == 0)
        retval = (SurfCompPrepAttributes_SetSurfaceType(self, tuple) != NULL);
    else if(strcmp(name, "coordSystem") == 0)
        retval = (SurfCompPrepAttributes_SetCoordSystem(self, tuple) != NULL);
    else if(strcmp(name, "thetaStart") == 0)
        retval = (SurfCompPrepAttributes_SetThetaStart(self, tuple) != NULL);
    else if(strcmp(name, "thetaStop") == 0)
        retval = (SurfCompPrepAttributes_SetThetaStop(self, tuple) != NULL);
    else if(strcmp(name, "thetaSteps") == 0)
        retval = (SurfCompPrepAttributes_SetThetaSteps(self, tuple) != NULL);
    else if(strcmp(name, "phiStart") == 0)
        retval = (SurfCompPrepAttributes_SetPhiStart(self, tuple) != NULL);
    else if(strcmp(name, "phiStop") == 0)
        retval = (SurfCompPrepAttributes_SetPhiStop(self, tuple) != NULL);
    else if(strcmp(name, "phiSteps") == 0)
        retval = (SurfCompPrepAttributes_SetPhiSteps(self, tuple) != NULL);
    else if(strcmp(name, "startRadius") == 0)
        retval = (SurfCompPrepAttributes_SetStartRadius(self, tuple) != NULL);
    else if(strcmp(name, "endRadius") == 0)
        retval = (SurfCompPrepAttributes_SetEndRadius(self, tuple) != NULL);
    else if(strcmp(name, "radiusSteps") == 0)
        retval = (SurfCompPrepAttributes_SetRadiusSteps(self, tuple) != NULL);
    else if(strcmp(name, "xStart") == 0)
        retval = (SurfCompPrepAttributes_SetXStart(self, tuple) != NULL);
    else if(strcmp(name, "xStop") == 0)
        retval = (SurfCompPrepAttributes_SetXStop(self, tuple) != NULL);
    else if(strcmp(name, "xSteps") == 0)
        retval = (SurfCompPrepAttributes_SetXSteps(self, tuple) != NULL);
    else if(strcmp(name, "yStart") == 0)
        retval = (SurfCompPrepAttributes_SetYStart(self, tuple) != NULL);
    else if(strcmp(name, "yStop") == 0)
        retval = (SurfCompPrepAttributes_SetYStop(self, tuple) != NULL);
    else if(strcmp(name, "ySteps") == 0)
        retval = (SurfCompPrepAttributes_SetYSteps(self, tuple) != NULL);
    else if(strcmp(name, "zStart") == 0)
        retval = (SurfCompPrepAttributes_SetZStart(self, tuple) != NULL);
    else if(strcmp(name, "zStop") == 0)
        retval = (SurfCompPrepAttributes_SetZStop(self, tuple) != NULL);
    else if(strcmp(name, "zSteps") == 0)
        retval = (SurfCompPrepAttributes_SetZSteps(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SurfCompPrepAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SurfCompPrepAttributesObject *obj = (SurfCompPrepAttributesObject *)v;

    const char *surfaceType_names = "Closest, Farthest, Average";
    if(obj->data->GetSurfaceType() == SurfCompPrepAttributes::Closest)
        fprintf(fp, "surfaceType = Closest  # %s\n", surfaceType_names);
    else if(obj->data->GetSurfaceType() == SurfCompPrepAttributes::Farthest)
        fprintf(fp, "surfaceType = Farthest  # %s\n", surfaceType_names);
    else
        fprintf(fp, "surfaceType = Average  # %s\n", surfaceType_names);

    const char *coordSystem_names = "Cartesian, Cylindrical, Spherical";
    if(obj->data->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
        fprintf(fp, "coordSystem = Cartesian  # %s\n", coordSystem_names);
    else if(obj->data->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
        fprintf(fp, "coordSystem = Cylindrical  # %s\n", coordSystem_names);
    else
        fprintf(fp, "coordSystem = Spherical  # %s\n", coordSystem_names);

    fprintf(fp, "thetaStart = %g\n", obj->data->GetThetaStart());
    fprintf(fp, "thetaStop = %g\n", obj->data->GetThetaStop());
    fprintf(fp, "thetaSteps = %d\n", obj->data->GetThetaSteps());
    fprintf(fp, "phiStart = %g\n", obj->data->GetPhiStart());
    fprintf(fp, "phiStop = %g\n", obj->data->GetPhiStop());
    fprintf(fp, "phiSteps = %d\n", obj->data->GetPhiSteps());
    fprintf(fp, "startRadius = %g\n", obj->data->GetStartRadius());
    fprintf(fp, "endRadius = %g\n", obj->data->GetEndRadius());
    fprintf(fp, "radiusSteps = %d\n", obj->data->GetRadiusSteps());
    fprintf(fp, "xStart = %g\n", obj->data->GetXStart());
    fprintf(fp, "xStop = %g\n", obj->data->GetXStop());
    fprintf(fp, "xSteps = %d\n", obj->data->GetXSteps());
    fprintf(fp, "yStart = %g\n", obj->data->GetYStart());
    fprintf(fp, "yStop = %g\n", obj->data->GetYStop());
    fprintf(fp, "ySteps = %d\n", obj->data->GetYSteps());
    fprintf(fp, "zStart = %g\n", obj->data->GetZStart());
    fprintf(fp, "zStop = %g\n", obj->data->GetZStop());
    fprintf(fp, "zSteps = %d\n", obj->data->GetZSteps());

    return 0;
}

//
// The doc string for the class.
//
static char *SurfCompPrepAttributes_Purpose = "Attributes for the SurfCompPrep operator.";

//
// The type description structure
//
static PyTypeObject SurfCompPrepAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SurfCompPrepAttributes",                    // tp_name
    sizeof(SurfCompPrepAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SurfCompPrepAttributes_dealloc,  // tp_dealloc
    (printfunc)SurfCompPrepAttributes_print,     // tp_print
    (getattrfunc)SurfCompPrepAttributes_getattr, // tp_getattr
    (setattrfunc)SurfCompPrepAttributes_setattr, // tp_setattr
    (cmpfunc)SurfCompPrepAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SurfCompPrepAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SurfCompPrepAttributes *defaultAtts = 0;

static PyObject *
NewSurfCompPrepAttributes()
{
    SurfCompPrepAttributesObject *newObject;
    newObject = PyObject_NEW(SurfCompPrepAttributesObject, &SurfCompPrepAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SurfCompPrepAttributes(*defaultAtts);
    else
        newObject->data = new SurfCompPrepAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSurfCompPrepAttributes(const SurfCompPrepAttributes *attr)
{
    SurfCompPrepAttributesObject *newObject;
    newObject = PyObject_NEW(SurfCompPrepAttributesObject, &SurfCompPrepAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SurfCompPrepAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SurfCompPrepAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSurfCompPrepAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SurfCompPrepAttributesMethods[] = {
    {"SurfCompPrepAttributes", SurfCompPrepAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SurfCompPrepAttributesObserver = 0;
static bool SurfCompPrepAttributesEnableLogging = true;

static void
PySurfCompPrepAttributes_WriteLog(Subject *subj, void *data)
{
    SurfCompPrepAttributes *atts = (SurfCompPrepAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SurfCompPrepAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SurfCompPrepAttributes_WriteLog()\n");
}

void
PySurfCompPrepAttributes_StartUp(SurfCompPrepAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySurfCompPrepAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SurfCompPrepAttributesObserver == 0)
    {
        SurfCompPrepAttributesObserver = new ObserverToCallback(subj,
            PySurfCompPrepAttributes_WriteLog, (void *)logFile);
    }

    SurfCompPrepAttributesEnableLogging = true;
}

void
PySurfCompPrepAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SurfCompPrepAttributesObserver;
    SurfCompPrepAttributesObserver = 0;
}

PyMethodDef *
PySurfCompPrepAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SurfCompPrepAttributesMethods;
}

bool
PySurfCompPrepAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SurfCompPrepAttributesType);
}

SurfCompPrepAttributes *
PySurfCompPrepAttributes_FromPyObject(PyObject *obj)
{
    SurfCompPrepAttributesObject *obj2 = (SurfCompPrepAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySurfCompPrepAttributes_NewPyObject()
{
    return NewSurfCompPrepAttributes();
}

PyObject *
PySurfCompPrepAttributes_WrapPyObject(const SurfCompPrepAttributes *attr)
{
    return WrapSurfCompPrepAttributes(attr);
}

void
PySurfCompPrepAttributes_SetLogging(bool val)
{
    SurfCompPrepAttributesEnableLogging = val;
}

void
PySurfCompPrepAttributes_SetDefaults(const SurfCompPrepAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SurfCompPrepAttributes(*atts);
}

