// ************************************************************************* //
//  File: SubdivideQuadsViewerPluginInfo.C
// ************************************************************************* //

#include <SubdivideQuadsPluginInfo.h>
#include <SubdivideQuadsAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo SubdivideQuads_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the SubdivideQuads operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    SubdivideQuadsViewerPluginInfo::InitializeGlobalObjects();
    return new SubdivideQuadsViewerPluginInfo;
}

//
// Storage for static data elements.
//
SubdivideQuadsAttributes *SubdivideQuadsViewerPluginInfo::clientAtts = NULL;
SubdivideQuadsAttributes *SubdivideQuadsViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SubdivideQuadsViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************
void
SubdivideQuadsViewerPluginInfo::InitializeGlobalObjects()
{
    SubdivideQuadsViewerPluginInfo::clientAtts  = new SubdivideQuadsAttributes;
    SubdivideQuadsViewerPluginInfo::defaultAtts = new SubdivideQuadsAttributes;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

AttributeSubject *
SubdivideQuadsViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

AttributeSubject *
SubdivideQuadsViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

void
SubdivideQuadsViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SubdivideQuadsAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

void
SubdivideQuadsViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SubdivideQuadsAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

void
SubdivideQuadsViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SubdivideQuadsAttributes*)atts = *defaultAtts;
    else
        *(SubdivideQuadsAttributes*)atts = *clientAtts;
}
