// ************************************************************************* //
//                        SubdivideQuadsScriptingPluginInfo.C
// ************************************************************************* //
#include <SubdivideQuadsPluginInfo.h>
#include <PySubdivideQuadsAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo SubdivideQuads_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the SubdivideQuads plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new SubdivideQuadsScriptingPluginInfo;
}

// ****************************************************************************
// Method: SubdivideQuadsScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SubdivideQuadsScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySubdivideQuadsAttributes_StartUp((SubdivideQuadsAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SubdivideQuadsScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void *
SubdivideQuadsScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySubdivideQuadsAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SubdivideQuadsScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is SubdivideQuads plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubdivideQuadsScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySubdivideQuadsAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SubdivideQuadsScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SubdivideQuadsScriptingPluginInfo::SetLogging(bool val)
{
    PySubdivideQuadsAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SubdivideQuadsScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SubdivideQuadsScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySubdivideQuadsAttributes_SetDefaults((const SubdivideQuadsAttributes *)atts);
}
