// ************************************************************************* //
//  File: SubdivideQuadsGUIPluginInfo.C
// ************************************************************************* //

#include <SubdivideQuadsPluginInfo.h>
#include <SubdivideQuadsAttributes.h>
#include <QvisSubdivideQuadsWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo SubdivideQuads_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the SubdivideQuads operator.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new SubdivideQuadsGUIPluginInfo;
}

// ****************************************************************************
//  Method: SubdivideQuadsGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

const char *
SubdivideQuadsGUIPluginInfo::GetMenuName() const
{
    return "SubdivideQuads";
}


// ****************************************************************************
//  Method: SubdivideQuadsGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
SubdivideQuadsGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSubdivideQuadsWindow(type, (SubdivideQuadsAttributes *)attr,
        "SubdivideQuads operator attributes", "SubdivideQuads operator", notepad);
}
