#include <PySubdivideQuadsAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySubdivideQuadsAttributes
//
// Purpose: 
//   Attributes for SubdivideQuads operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Nov 2 06:28:41 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a SubdivideQuadsAttributes.
//
struct SubdivideQuadsAttributesObject
{
    PyObject_HEAD
    SubdivideQuadsAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSubdivideQuadsAttributes();

static PyObject *
SubdivideQuadsAttributes_Notify(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_SetThreshold(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the threshold in the object.
    obj->data->SetThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_GetThreshold(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThreshold());
    return retval;
}

static PyObject *
SubdivideQuadsAttributes_SetMaxSubdivs(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSubdivs in the object.
    obj->data->SetMaxSubdivs(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_GetMaxSubdivs(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSubdivs()));
    return retval;
}

static PyObject *
SubdivideQuadsAttributes_SetFanOutPoints(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fanOutPoints in the object.
    obj->data->SetFanOutPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_GetFanOutPoints(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFanOutPoints()?1L:0L);
    return retval;
}

static PyObject *
SubdivideQuadsAttributes_SetDoTriangles(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTriangles in the object.
    obj->data->SetDoTriangles(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_GetDoTriangles(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTriangles()?1L:0L);
    return retval;
}

static PyObject *
SubdivideQuadsAttributes_SetVariable(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubdivideQuadsAttributes_GetVariable(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef SubdivideQuadsAttributes_methods[] = {
    {"Notify", SubdivideQuadsAttributes_Notify, METH_VARARGS},
    {"SetThreshold", SubdivideQuadsAttributes_SetThreshold, METH_VARARGS},
    {"GetThreshold", SubdivideQuadsAttributes_GetThreshold, METH_VARARGS},
    {"SetMaxSubdivs", SubdivideQuadsAttributes_SetMaxSubdivs, METH_VARARGS},
    {"GetMaxSubdivs", SubdivideQuadsAttributes_GetMaxSubdivs, METH_VARARGS},
    {"SetFanOutPoints", SubdivideQuadsAttributes_SetFanOutPoints, METH_VARARGS},
    {"GetFanOutPoints", SubdivideQuadsAttributes_GetFanOutPoints, METH_VARARGS},
    {"SetDoTriangles", SubdivideQuadsAttributes_SetDoTriangles, METH_VARARGS},
    {"GetDoTriangles", SubdivideQuadsAttributes_GetDoTriangles, METH_VARARGS},
    {"SetVariable", SubdivideQuadsAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", SubdivideQuadsAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SubdivideQuadsAttributes_dealloc(PyObject *v)
{
   SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SubdivideQuadsAttributes_compare(PyObject *v, PyObject *w)
{
    SubdivideQuadsAttributes *a = ((SubdivideQuadsAttributesObject *)v)->data;
    SubdivideQuadsAttributes *b = ((SubdivideQuadsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SubdivideQuadsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "threshold") == 0)
        return SubdivideQuadsAttributes_GetThreshold(self, NULL);
    if(strcmp(name, "maxSubdivs") == 0)
        return SubdivideQuadsAttributes_GetMaxSubdivs(self, NULL);
    if(strcmp(name, "fanOutPoints") == 0)
        return SubdivideQuadsAttributes_GetFanOutPoints(self, NULL);
    if(strcmp(name, "doTriangles") == 0)
        return SubdivideQuadsAttributes_GetDoTriangles(self, NULL);
    if(strcmp(name, "variable") == 0)
        return SubdivideQuadsAttributes_GetVariable(self, NULL);

    return Py_FindMethod(SubdivideQuadsAttributes_methods, self, name);
}

static int
SubdivideQuadsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "threshold") == 0)
        retval = (SubdivideQuadsAttributes_SetThreshold(self, tuple) != NULL);
    else if(strcmp(name, "maxSubdivs") == 0)
        retval = (SubdivideQuadsAttributes_SetMaxSubdivs(self, tuple) != NULL);
    else if(strcmp(name, "fanOutPoints") == 0)
        retval = (SubdivideQuadsAttributes_SetFanOutPoints(self, tuple) != NULL);
    else if(strcmp(name, "doTriangles") == 0)
        retval = (SubdivideQuadsAttributes_SetDoTriangles(self, tuple) != NULL);
    else if(strcmp(name, "variable") == 0)
        retval = (SubdivideQuadsAttributes_SetVariable(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SubdivideQuadsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;

    fprintf(fp, "threshold = %g\n", obj->data->GetThreshold());
    fprintf(fp, "maxSubdivs = %d\n", obj->data->GetMaxSubdivs());
    if(obj->data->GetFanOutPoints())
        fprintf(fp, "fanOutPoints = 1\n");
    else
        fprintf(fp, "fanOutPoints = 0\n");
    if(obj->data->GetDoTriangles())
        fprintf(fp, "doTriangles = 1\n");
    else
        fprintf(fp, "doTriangles = 0\n");
    fprintf(fp, "variable = \"%s\"\n", obj->data->GetVariable().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PySubdivideQuadsAttributes_StringRepresentation(const SubdivideQuadsAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "threshold = %g\n", atts->GetThreshold());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "maxSubdivs = %d\n", atts->GetMaxSubdivs());
    str += tmpStr;
    if(atts->GetFanOutPoints())
        SNPRINTF(tmpStr, 1000, "fanOutPoints = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "fanOutPoints = 0\n");
    str += tmpStr;
    if(atts->GetDoTriangles())
        SNPRINTF(tmpStr, 1000, "doTriangles = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doTriangles = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "variable = \"%s\"\n", atts->GetVariable().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
SubdivideQuadsAttributes_str(PyObject *v)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;
    return PySubdivideQuadsAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *SubdivideQuadsAttributes_Purpose = "Attributes for SubdivideQuads operator";

//
// The type description structure
//
static PyTypeObject SubdivideQuadsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SubdivideQuadsAttributes",                    // tp_name
    sizeof(SubdivideQuadsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SubdivideQuadsAttributes_dealloc,  // tp_dealloc
    (printfunc)SubdivideQuadsAttributes_print,     // tp_print
    (getattrfunc)SubdivideQuadsAttributes_getattr, // tp_getattr
    (setattrfunc)SubdivideQuadsAttributes_setattr, // tp_setattr
    (cmpfunc)SubdivideQuadsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SubdivideQuadsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SubdivideQuadsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SubdivideQuadsAttributes *defaultAtts = 0;

static PyObject *
NewSubdivideQuadsAttributes()
{
    SubdivideQuadsAttributesObject *newObject;
    newObject = PyObject_NEW(SubdivideQuadsAttributesObject, &SubdivideQuadsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SubdivideQuadsAttributes(*defaultAtts);
    else
        newObject->data = new SubdivideQuadsAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSubdivideQuadsAttributes(const SubdivideQuadsAttributes *attr)
{
    SubdivideQuadsAttributesObject *newObject;
    newObject = PyObject_NEW(SubdivideQuadsAttributesObject, &SubdivideQuadsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SubdivideQuadsAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SubdivideQuadsAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSubdivideQuadsAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SubdivideQuadsAttributesMethods[] = {
    {"SubdivideQuadsAttributes", SubdivideQuadsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SubdivideQuadsAttributesObserver = 0;
static bool SubdivideQuadsAttributesEnableLogging = true;

static void
PySubdivideQuadsAttributes_WriteLog(Subject *subj, void *data)
{
    SubdivideQuadsAttributes *atts = (SubdivideQuadsAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SubdivideQuadsAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SubdivideQuadsAttributes_WriteLog()\n");
}

void
PySubdivideQuadsAttributes_StartUp(SubdivideQuadsAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySubdivideQuadsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SubdivideQuadsAttributesObserver == 0)
    {
        SubdivideQuadsAttributesObserver = new ObserverToCallback(subj,
            PySubdivideQuadsAttributes_WriteLog, (void *)logFile);
    }

    SubdivideQuadsAttributesEnableLogging = true;
}

void
PySubdivideQuadsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SubdivideQuadsAttributesObserver;
    SubdivideQuadsAttributesObserver = 0;
}

PyMethodDef *
PySubdivideQuadsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SubdivideQuadsAttributesMethods;
}

bool
PySubdivideQuadsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SubdivideQuadsAttributesType);
}

SubdivideQuadsAttributes *
PySubdivideQuadsAttributes_FromPyObject(PyObject *obj)
{
    SubdivideQuadsAttributesObject *obj2 = (SubdivideQuadsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySubdivideQuadsAttributes_NewPyObject()
{
    return NewSubdivideQuadsAttributes();
}

PyObject *
PySubdivideQuadsAttributes_WrapPyObject(const SubdivideQuadsAttributes *attr)
{
    return WrapSubdivideQuadsAttributes(attr);
}

void
PySubdivideQuadsAttributes_SetLogging(bool val)
{
    SubdivideQuadsAttributesEnableLogging = val;
}

void
PySubdivideQuadsAttributes_SetDefaults(const SubdivideQuadsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SubdivideQuadsAttributes(*atts);
}

