// ************************************************************************* //
//  File: avtSphereSliceFilter.C
// ************************************************************************* //

#include <avtSphereSliceFilter.h>

#include <vtkCutter.h>
#include <vtkPolyData.h>
#include <vtkQuadric.h>


// ****************************************************************************
//  Method: avtSphereSliceFilter constructor
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

avtSphereSliceFilter::avtSphereSliceFilter()
{
    quadric = vtkQuadric::New();
}


// ****************************************************************************
//  Method: avtSphereSliceFilter destructor
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//
// ****************************************************************************

avtSphereSliceFilter::~avtSphereSliceFilter()
{
    if (quadric != NULL)
    {
        quadric->Delete();
        quadric = NULL;
    }
}


// ****************************************************************************
//  Method:  avtSphereSliceFilter::Create
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

avtFilter *
avtSphereSliceFilter::Create()
{
    return new avtSphereSliceFilter();
}


// ****************************************************************************
//  Method:      avtSphereSliceFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

void
avtSphereSliceFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const SphereSliceAttributes*)a;
    origin[0] = atts.GetOrigin()[0];
    origin[1] = atts.GetOrigin()[1];
    origin[2] = atts.GetOrigin()[2];
    radius    = atts.GetRadius();

    float coeffs[10];

    coeffs[0] = 1.;
    coeffs[1] = 1.;
    coeffs[2] = 1.;
    coeffs[3] = 0.;
    coeffs[4] = 0.;
    coeffs[5] = 0.;
    coeffs[6] = -2. * origin[0];
    coeffs[7] = -2. * origin[1];
    coeffs[8] = -2. * origin[2];
    coeffs[9] = origin[0] * origin[0] + origin[1] * origin[1] +
                origin[2] * origin[2] - radius * radius;
    quadric->SetCoefficients(coeffs);
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtSphereSliceFilter with the given
//      parameters would result in an equivalent avtSphereSliceFilter.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

bool
avtSphereSliceFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(SphereSliceAttributes*)a);
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the SphereSlice filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//
//    Hank Childs, Tue Sep 10 18:25:27 PDT 2002
//    Made all memory management internal to this routine.
//
// ****************************************************************************

vtkDataSet *
avtSphereSliceFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkCutter *cutter = vtkCutter::New();
    cutter->SetCutFunction(quadric);
    cutter->SetInput(in_ds);
    cutter->Update();

    vtkDataSet *out_ds = cutter->GetOutput();
    if (out_ds->GetNumberOfCells() == 0)
    {
        out_ds = NULL;
    }

    ManageMemory(out_ds);
    cutter->Delete();
    return out_ds;
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::RefashionDataObjectInfo
//
//  Purpose:
//      Changes to topological dimension of the output to be one less that the
//      input.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

void
avtSphereSliceFilter::RefashionDataObjectInfo(void)
{
    avtDataAttributes &inAtts      = GetInput()->GetInfo().GetAttributes();
    avtDataAttributes &outAtts     = GetOutput()->GetInfo().GetAttributes();
    avtDataValidity   &outValidity = GetOutput()->GetInfo().GetValidity();

    outAtts.SetTopologicalDimension(inAtts.GetTopologicalDimension()-1);
    outValidity.InvalidateZones();
}
