// ************************************************************************* //
//  File: SphereSliceViewerPluginInfo.C
// ************************************************************************* //

#include <SphereSlicePluginInfo.h>
#include <SphereSliceAttributes.h>

#if defined(__APPLE__)
#define GetViewerInfo SphereSlice_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the SphereSlice operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    SphereSliceViewerPluginInfo::InitializeGlobalObjects();
    return new SphereSliceViewerPluginInfo;
}

//
// Storage for static data elements.
//
SphereSliceAttributes *SphereSliceViewerPluginInfo::clientAtts = NULL;
SphereSliceAttributes *SphereSliceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SphereSliceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************
void
SphereSliceViewerPluginInfo::InitializeGlobalObjects()
{
    SphereSliceViewerPluginInfo::clientAtts  = new SphereSliceAttributes;
    SphereSliceViewerPluginInfo::defaultAtts = new SphereSliceAttributes;
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

AttributeSubject *
SphereSliceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

AttributeSubject *
SphereSliceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

void
SphereSliceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SphereSliceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

void
SphereSliceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SphereSliceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

void
SphereSliceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SphereSliceAttributes*)atts = *defaultAtts;
    else
        *(SphereSliceAttributes*)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SphereSliceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:31 PST 2003
//
// ****************************************************************************

#include <SphereSlice.xpm>
const char **
SphereSliceViewerPluginInfo::XPMIconData() const
{
    return SphereSlice_xpm;
}
