// ************************************************************************* //
//                        SphereSliceScriptingPluginInfo.C
// ************************************************************************* //
#include <SphereSlicePluginInfo.h>
#include <PySphereSliceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo SphereSlice_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the SphereSlice plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new SphereSliceScriptingPluginInfo;
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SphereSliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySphereSliceAttributes_StartUp((SphereSliceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
SphereSliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySphereSliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is SphereSlice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
SphereSliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySphereSliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SphereSliceScriptingPluginInfo::SetLogging(bool val)
{
    PySphereSliceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SphereSliceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:37:04 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SphereSliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySphereSliceAttributes_SetDefaults((const SphereSliceAttributes *)atts);
}
