// ************************************************************************* //
//  File: SphereSliceGUIPluginInfo.C
// ************************************************************************* //

#include <SphereSlicePluginInfo.h>
#include <SphereSliceAttributes.h>
#include <QvisSphereSliceWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo SphereSlice_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the SphereSlice operator.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:31:30 PST 2003
//
// ****************************************************************************
extern "C" GUIOperatorPluginInfo* GetGUIInfo()
{
    return new SphereSliceGUIPluginInfo;
}

// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:31:30 PST 2003
//
// ****************************************************************************

const char *
SphereSliceGUIPluginInfo::GetMenuName() const
{
    return "Spherical Slice";
}


// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:31:30 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
SphereSliceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSphereSliceWindow(type, (SphereSliceAttributes *)attr,
        "Spherical Slice operator attributes", "SphereSlice operator", notepad);
}

// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 15:31:30 PST 2003
//
// ****************************************************************************

#include <SphereSlice.xpm>
const char **
SphereSliceGUIPluginInfo::XPMIconData() const
{
    return SphereSlice_xpm;
}
