package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: SphereSliceAttributes
//
// Purpose:
//    This class contains attributes for the spherical slice.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:09:28 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class SphereSliceAttributes extends AttributeSubject implements Plugin
{
    public SphereSliceAttributes()
    {
        super(2);

        origin = new double[3];
        origin[0] = 0;
        origin[1] = 0;
        origin[2] = 0;
        radius = 1;
    }

    public SphereSliceAttributes(SphereSliceAttributes obj)
    {
        super(2);

        int i;

        origin = new double[3];
        origin[0] = obj.origin[0];
        origin[1] = obj.origin[1];
        origin[2] = obj.origin[2];

        radius = obj.radius;

        SelectAll();
    }

    public boolean equals(SphereSliceAttributes obj)
    {
        int i;

        // Compare the origin arrays.
        boolean origin_equal = true;
        for(i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        // Create the return value
        return (origin_equal &&
                (radius == obj.radius));
    }

    public String GetName() { return "SphereSlice"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetOrigin(double[] origin_)
    {
        origin[0] = origin_[0];
        origin[1] = origin_[1];
        origin[2] = origin_[2];
        Select(0);
    }

    public void SetOrigin(double e0, double e1, double e2)
    {
        origin[0] = e0;
        origin[1] = e1;
        origin[2] = e2;
        Select(0);
    }

    public void SetRadius(double radius_)
    {
        radius = radius_;
        Select(1);
    }

    // Property getting methods
    public double[] GetOrigin() { return origin; }
    public double   GetRadius() { return radius; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDoubleArray(origin);
        if(WriteSelect(1, buf))
            buf.WriteDouble(radius);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetOrigin(buf.ReadDoubleArray());
                break;
            case 1:
                SetRadius(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private double[] origin;
    private double   radius;
}

