// ************************************************************************* //
//  File: SliceViewerPluginInfo.C
// ************************************************************************* //

#include <SlicePluginInfo.h>
#include <SliceAttributes.h>

#include <avtDatabaseMetaData.h>
#include <ViewerPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Slice_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Slice operator.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************
extern "C" ViewerOperatorPluginInfo* GetViewerInfo()
{
    SliceViewerPluginInfo::InitializeGlobalObjects();
    return new SliceViewerPluginInfo;
}

//
// Storage for static data elements.
//
SliceAttributes *SliceViewerPluginInfo::clientAtts = NULL;
SliceAttributes *SliceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SliceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************
void
SliceViewerPluginInfo::InitializeGlobalObjects()
{
    SliceViewerPluginInfo::clientAtts  = new SliceAttributes;
    SliceViewerPluginInfo::defaultAtts = new SliceAttributes;
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************

AttributeSubject *
SliceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************

AttributeSubject *
SliceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************

void
SliceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SliceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************

void
SliceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SliceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
//  Modifications:
//    Kathleen Bonnell, Mon Jan 31 16:36:38 PST 2005
//    Set the atts' meshName from the plot.
//
// ****************************************************************************

void
SliceViewerPluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const ViewerPlot *plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SliceAttributes*)atts = *defaultAtts;
    else
        *(SliceAttributes*)atts = *clientAtts;

    SliceAttributes *sliceAtts = (SliceAttributes*)atts;
    if (sliceAtts->GetMeshName() == "default")
    {
        const avtDatabaseMetaData *dbmd = plot->GetMetaData();
        if (dbmd)
        {
            sliceAtts->SetMeshName(dbmd->MeshForVar(plot->GetVariableName()));
        }
    }
}

// ****************************************************************************
//  Method: SliceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
// ****************************************************************************

#include <Slice.xpm>
const char **
SliceViewerPluginInfo::XPMIconData() const
{
    return Slice_xpm;
}
