// ************************************************************************* //
//                        SliceScriptingPluginInfo.C
// ************************************************************************* //
#include <SlicePluginInfo.h>
#include <PySliceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Slice_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Slice plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// ****************************************************************************
extern "C" ScriptingOperatorPluginInfo* GetScriptingInfo()
{
    return new SliceScriptingPluginInfo;
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySliceAttributes_StartUp((SliceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
SliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Slice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
SliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SliceScriptingPluginInfo::SetLogging(bool val)
{
    PySliceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Sun Nov 17 16:53:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySliceAttributes_SetDefaults((const SliceAttributes *)atts);
}
