// ************************************************************************* //
//  File: SlicePluginInfo.h
// ************************************************************************* //

#ifndef SLICE_PLUGIN_INFO_H
#define SLICE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class SliceAttributes;

// ****************************************************************************
//  Class: SlicePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Slice operator
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Tue Sep 9 16:05:17 PST 2003
//
//  Modifications:
//
// ****************************************************************************

class SliceGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class SliceCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual SliceGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SliceGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual SliceCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class SliceViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual SliceCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const ViewerPlot *plot,
                                        const bool fromDefault);
    virtual const char **XPMIconData() const;

    static void InitializeGlobalObjects();
  private:
    static SliceAttributes *defaultAtts;
    static SliceAttributes *clientAtts;
};

class SliceEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual SliceCommonPluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class SliceScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual SliceCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
